/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that handles saves.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface SaveControllerService {

    /**
     * Save the form.
     *
     * <p>Save is not implemented by KRAD and must be overridden with an implementation to persist changes
     * to a db.  By default, this will just refresh the View.</p>
     *
     * @param form the form
     * @return ModelAndView with the updated content
     */
    ModelAndView save(UifFormBase form);

    /**
     * Save the field of the form at the propertyName specified by saveFieldPath (in request params sent); the
     * field is already updated on the form at the time of this invocation.
     *
     * <p>SaveField is not implemented by KRAD and must be overridden with an implementation to persist changes
     * to a db.  By default, this will just refresh the field specified by updateComponentId.</p>
     *
     * @param form the form with the updated field
     * @return ModelAndView which contains the updated component
     */
    ModelAndView saveField(UifFormBase form);

}
