/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;

@BeanTag(name="supportAttributeDefinition")
public class SupportAttributeDefinition
extends PrimitiveAttributeDefinition {
    private static final Logger LOG = LogManager.getLogger(SupportAttributeDefinition.class);
    private static final long serialVersionUID = -1719022365280776405L;
    protected boolean identifier;

    @BeanTagAttribute(name="identifier")
    public boolean isIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(boolean identifier) {
        this.identifier = identifier;
    }

    @Override
    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        this.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass, new ValidationTrace());
    }

    @Override
    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        tracer.addBean(this.getClass().getSimpleName(), "NOBEANID");
        try {
            String[] currentValues;
            if (!DataDictionaryPropertyUtils.isPropertyOf(rootBusinessObjectClass, this.getSourceName())) {
                currentValues = new String[]{"attribute = " + this.getSourceName(), "class = " + String.valueOf(rootBusinessObjectClass)};
                tracer.createError("Unable to find attribute in class", currentValues);
            }
            if (!DataDictionaryPropertyUtils.isPropertyOf(otherBusinessObjectClass, this.getTargetName()) && !ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface((Class)otherBusinessObjectClass)) {
                currentValues = new String[]{"attribute = " + this.getTargetName(), "class = " + String.valueOf(otherBusinessObjectClass)};
                tracer.createError("Unable to find attribute in class", currentValues);
            }
        }
        catch (RuntimeException ex) {
            String[] currentValues = new String[]{"Exception = " + ex.getMessage()};
            tracer.createError("Unable to validate attribute", currentValues);
            LOG.error("Exception while validating SupportAttributeDefintion on " + String.valueOf(rootBusinessObjectClass) + ": " + String.valueOf(this), (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SupportAttributeDefinition [identifier=").append(this.identifier).append(", sourceName=").append(this.sourceName).append(", targetName=").append(this.targetName).append("]");
        return builder.toString();
    }
}

