/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.result;

import java.util.LinkedList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;

public class ConstraintValidationResult {
    private String entryName;
    private String attributeName;
    private String attributePath;
    private String constraintName;
    private ErrorLevel level;
    private String errorKey;
    private String[] errorParameters = new String[0];
    private String constraintLabelKey;
    private List<ConstraintValidationResult> children;

    public ConstraintValidationResult(String constraintName) {
        this.constraintName = constraintName;
        this.children = new LinkedList<ConstraintValidationResult>();
        this.level = ErrorLevel.OK;
    }

    public ConstraintValidationResult(String constraintName, ErrorLevel level) {
        this.constraintName = constraintName;
        this.children = new LinkedList<ConstraintValidationResult>();
        this.level = level;
    }

    public void addChild(ConstraintValidationResult child) {
        this.children.add(child);
    }

    public void setError(String errorKey, String ... errorParameters) {
        this.level = ErrorLevel.ERROR;
        this.errorKey = errorKey;
        this.errorParameters = errorParameters;
    }

    public void setWarning(String errorKey, String ... errorParameters) {
        this.level = ErrorLevel.WARN;
        this.errorKey = errorKey;
        this.errorParameters = errorParameters;
    }

    public ErrorLevel getStatus() {
        return this.level;
    }

    public void setStatus(ErrorLevel level) {
        this.level = level;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public String[] getErrorParameters() {
        return this.errorParameters;
    }

    public void setErrorParameters(String[] errorParameters) {
        this.errorParameters = errorParameters;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public List<ConstraintValidationResult> getChildren() {
        return this.children;
    }

    public String getConstraintLabelKey() {
        return this.constraintLabelKey;
    }

    public void setConstraintLabelKey(String constraintLabelKey) {
        this.constraintLabelKey = constraintLabelKey;
    }

    public String getAttributePath() {
        return this.attributePath;
    }

    public void setAttributePath(String attributePath) {
        this.attributePath = attributePath;
    }
}

