/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentControllerService;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.rule.event.AddNoteEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.DocumentView;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.kuali.rice.krad.web.service.impl.ControllerServiceImpl;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

public class DocumentControllerServiceImpl
extends ControllerServiceImpl
implements DocumentControllerService {
    private static final Logger LOG = LogManager.getLogger(DocumentControllerServiceImpl.class);
    protected static final String[] DOCUMENT_LOAD_COMMANDS = new String[]{"displayActionListView", "displayDocSearchView", "displaySuperUserView", "displayHelpDeskActionListView"};
    protected static final String SENSITIVE_DATA_DIALOG = "DialogGroup-SensitiveData";
    protected static final String EXPLANATION_DIALOG = "DisapproveExplanationDialog";
    private LegacyDataAdapter legacyDataAdapter;
    private DataDictionaryService dataDictionaryService;
    private DocumentService documentService;
    private DocumentDictionaryService documentDictionaryService;
    private AttachmentService attachmentService;
    private NoteService noteService;
    private ModelAndViewService modelAndViewService;
    private NavigationControllerService navigationControllerService;
    private ConfigurationService configurationService;
    private CollectionControllerService collectionControllerService;
    private ParameterService parameterService;

    @Override
    public ModelAndView docHandler(DocumentFormBase form) throws WorkflowException {
        String command = form.getCommand();
        DocumentView view = (DocumentView)form.getView();
        if (ArrayUtils.contains((Object[])DOCUMENT_LOAD_COMMANDS, (Object)command) && form.getDocId() != null) {
            this.checkReturnLocationForDocSearch(command, form);
            this.loadDocument(form);
            if ("displaySuperUserView".equals(command)) {
                view.setSuperUserView(true);
            }
        } else if ("initiate".equals(command)) {
            if (view != null) {
                form.setApplyDefaultValues(true);
            }
            this.createDocument(form);
        } else {
            LOG.error("docHandler called with invalid parameters");
            throw new IllegalArgumentException("docHandler called with invalid parameters");
        }
        return this.getModelAndViewService().getModelAndView(form);
    }

    private void checkReturnLocationForDocSearch(String command, DocumentFormBase form) {
        if ("displayDocSearchView".equals(command) && StringUtils.isBlank((String)form.getReturnLocation())) {
            form.setReturnLocation(ConfigContext.getCurrentContextConfig().getProperty("application.url"));
        }
    }

    protected void loadDocument(DocumentFormBase form) throws WorkflowException {
        Document document;
        String docId = form.getDocId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading document" + docId);
        }
        if ((document = this.getDocumentService().getByDocumentHeaderId(docId)) == null) {
            throw new UnknownDocumentIdException("Document no longer exists.  It may have been cancelled before being saved.");
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!this.getDocumentDictionaryService().getDocumentAuthorizer(document).canOpen(document, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("open", document);
        }
        if (workflowDocument != document.getDocumentHeader().getWorkflowDocument()) {
            LOG.warn("Workflow document changed via canOpen check");
            document.getDocumentHeader().setWorkflowDocument(workflowDocument);
        }
        form.setDocument(document);
        form.setDocTypeName(workflowDocument.getDocumentTypeName());
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)workflowDocument);
    }

    protected void createDocument(DocumentFormBase form) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new document instance for doc type: " + form.getDocTypeName());
        }
        Document doc = this.getDocumentService().getNewDocument(form.getDocTypeName());
        form.setDocument(doc);
        form.setDocTypeName(doc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    @Override
    public ModelAndView cancel(UifFormBase form) {
        this.performWorkflowAction((DocumentFormBase)form, UifConstants.WorkflowAction.CANCEL);
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView reload(DocumentFormBase form) throws WorkflowException {
        Document document = form.getDocument();
        form.setDocId(document.getDocumentNumber());
        form.setCommand(DOCUMENT_LOAD_COMMANDS[1]);
        form.setEvaluateFlagsAndModes(true);
        form.setCanEditView(null);
        GlobalVariables.getMessageMap().putInfo("GlobalMessages", "message.document.reloaded", new String[0]);
        return this.docHandler(form);
    }

    @Override
    public ModelAndView recall(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.RECALL);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView save(DocumentFormBase form) {
        return this.save(form, null);
    }

    @Override
    public ModelAndView save(DocumentFormBase form, SaveDocumentEvent saveDocumentEvent) {
        Document document = form.getDocument();
        String explanation = document.getDocumentHeader().getExplanation();
        ModelAndView sensitiveDataDialogModelAndView = this.checkSensitiveDataAndWarningDialog(explanation, form);
        if (sensitiveDataDialogModelAndView != null) {
            return sensitiveDataDialogModelAndView;
        }
        this.performWorkflowAction(form, UifConstants.WorkflowAction.SAVE, saveDocumentEvent);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView complete(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.COMPLETE);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView route(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.ROUTE);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView blanketApprove(DocumentFormBase form) {
        Document document = form.getDocument();
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        ArrayList<Object> adHocRecipients = new ArrayList<Object>();
        adHocRecipients.addAll(document.getAdHocRoutePersons());
        adHocRecipients.addAll(document.getAdHocRouteWorkgroups());
        for (AdHocRouteRecipient adHocRouteRecipient : adHocRecipients) {
            String actionRequestedCode = adHocRouteRecipient.getActionRequested();
            if (!"C".equals(actionRequestedCode)) continue;
            GlobalVariables.getMessageMap().putError("newAdHocRouteWorkgroup", "error.adhoc.complete.blanket.approve.not.allowed", new String[0]);
            return this.getModelAndViewService().getModelAndView(form);
        }
        this.performWorkflowAction(form, UifConstants.WorkflowAction.BLANKETAPPROVE);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView approve(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.APPROVE);
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView disapprove(DocumentFormBase form) {
        String explanationData = this.generateDisapprovalNote(form);
        ModelAndView sensitiveDataDialogModelAndView = this.checkSensitiveDataAndWarningDialog(explanationData, form);
        if (sensitiveDataDialogModelAndView != null) {
            return sensitiveDataDialogModelAndView;
        }
        this.performWorkflowAction(form, UifConstants.WorkflowAction.DISAPPROVE);
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    protected String generateDisapprovalNote(DocumentFormBase form) {
        String explanationData = form.getDialogExplanations().get(EXPLANATION_DIALOG);
        if (explanationData == null) {
            return "";
        }
        String introNoteMessage = this.getConfigurationService().getPropertyValueAsString("message.disapprove.noteTextIntro") + " ";
        return introNoteMessage + explanationData;
    }

    @Override
    public ModelAndView fyi(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.FYI);
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView acknowledge(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.ACKNOWLEDGE);
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView sendAdHocRequests(DocumentFormBase form) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.SENDADHOCREQUESTS);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView supervisorFunctions(DocumentFormBase form) {
        String workflowSuperUserUrl = this.getConfigurationService().getPropertyValueAsString("workflow.url") + "/SuperUser.do";
        Properties props = new Properties();
        props.setProperty("methodToCall", "displaySuperUserDocument");
        props.setProperty("documentId", form.getDocument().getDocumentNumber());
        return this.getModelAndViewService().performRedirect(form, workflowSuperUserUrl, props);
    }

    @Override
    public ModelAndView close(DocumentFormBase form) {
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @Override
    public ModelAndView insertNote(DocumentFormBase form) {
        ModelAndView sensitiveDataDialogModelAndView;
        Document document = form.getDocument();
        Note newNote = this.getAddLineNoteInstance(form);
        this.setNewNoteProperties(form, document, newNote);
        Attachment attachment = this.getNewNoteAttachment(form, document, newNote);
        boolean rulesPassed = KRADServiceLocatorWeb.getKualiRuleService().applyRules(new AddNoteEvent(document, newNote));
        if (!rulesPassed) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        if (attachment != null) {
            newNote.addAttachment(attachment);
        }
        if ((sensitiveDataDialogModelAndView = this.checkSensitiveDataAndWarningDialog(newNote.getNoteText(), form)) != null) {
            return sensitiveDataDialogModelAndView;
        }
        this.saveNewNote(form, document, newNote);
        return this.getCollectionControllerService().addLine(form);
    }

    protected Note getAddLineNoteInstance(DocumentFormBase form) {
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        BindingInfo addLineBindingInfo = (BindingInfo)form.getViewPostMetadata().getComponentPostData(selectedCollectionId, "addLineBindingInfo");
        String addLinePath = addLineBindingInfo.getBindingPath();
        Object addLine = ObjectPropertyUtils.getPropertyValue(form, addLinePath);
        return (Note)addLine;
    }

    protected void setNewNoteProperties(DocumentFormBase form, Document document, Note newNote) {
        newNote.setNotePostedTimestampToCurrent();
        newNote.setRemoteObjectIdentifier(document.getNoteTarget().getObjectId());
        Person kualiUser = GlobalVariables.getUserSession().getPerson();
        if (kualiUser == null) {
            throw new IllegalStateException("Current UserSession has a null Person.");
        }
        newNote.setAuthorUniversalIdentifier(kualiUser.getPrincipalId());
    }

    protected Attachment getNewNoteAttachment(DocumentFormBase form, Document document, Note newNote) {
        Attachment attachment;
        DocumentAuthorizer documentAuthorizer;
        MultipartFile attachmentFile = form.getAttachmentFile();
        if (attachmentFile == null || StringUtils.isBlank((String)attachmentFile.getOriginalFilename())) {
            return null;
        }
        if (attachmentFile.getSize() == 0L) {
            GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.empty", new String[]{attachmentFile.getOriginalFilename()});
            return null;
        }
        String attachmentTypeCode = null;
        if (newNote.getAttachment() != null) {
            attachmentTypeCode = newNote.getAttachment().getAttachmentTypeCode();
        }
        if (!(documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(document)).canAddNoteAttachment(document, attachmentTypeCode, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("annotate", document);
        }
        try {
            attachment = this.getAttachmentService().createAttachment(document.getNoteTarget(), attachmentFile.getOriginalFilename(), attachmentFile.getContentType(), (int)attachmentFile.getSize(), attachmentFile.getInputStream(), attachmentTypeCode);
        }
        catch (IOException e) {
            throw new RiceRuntimeException("Unable to store attachment", (Throwable)e);
        }
        return attachment;
    }

    protected void saveNewNote(DocumentFormBase form, Document document, Note newNote) {
        DocumentHeader documentHeader = document.getDocumentHeader();
        if (!(documentHeader.getWorkflowDocument().isInitiated() || !StringUtils.isNotEmpty((String)document.getNoteTarget().getObjectId()) || document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(newNote.getNoteTypeCode()))) {
            this.getNoteService().save(newNote);
        }
    }

    @Override
    public ModelAndView deleteNote(DocumentFormBase form) {
        String selectedLineIndex = form.getActionParamaterValue("selectedLineIndex");
        Document document = form.getDocument();
        Note note = document.getNote(Integer.parseInt(selectedLineIndex));
        Attachment attachment = note.getAttachment();
        String attachmentTypeCode = null;
        if (attachment != null) {
            attachmentTypeCode = attachment.getAttachmentTypeCode();
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!this.getDocumentDictionaryService().getDocumentAuthorizer(document).canDeleteNoteAttachment(document, attachmentTypeCode, note.getAuthorUniversalIdentifier(), user)) {
            throw this.buildAuthorizationException("annotate", document);
        }
        if (attachment != null && attachment.isComplete()) {
            this.getAttachmentService().deleteAttachmentContents(attachment);
        }
        if (!document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getNoteService().deleteNote(note);
        }
        return this.getCollectionControllerService().deleteLine(form);
    }

    @Override
    public ModelAndView downloadAttachment(DocumentFormBase form, HttpServletResponse response) {
        Attachment attachment = null;
        String selectedLineIndex = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotBlank((String)selectedLineIndex)) {
            Note note = form.getDocument().getNote(Integer.parseInt(selectedLineIndex));
            attachment = note.getAttachment();
        } else {
            Long noteIdentifier = Long.valueOf(form.getActionParamaterValue("noteIdentifier"));
            Note note = this.getNoteService().getNoteByNoteId(noteIdentifier);
            if (note != null && note.getAttachment() != null) {
                attachment = note.getAttachment();
                attachment.setNote(note);
            }
        }
        if (attachment == null) {
            throw new RuntimeException("Unable to find attachment for action parameters passed.");
        }
        try {
            KRADUtils.addAttachmentToResponse(response, this.getAttachmentService().retrieveAttachmentContents(attachment), attachment.getAttachmentMimeTypeCode(), attachment.getAttachmentFileName(), attachment.getAttachmentFileSize());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to download note attachment", e);
        }
        return null;
    }

    @Override
    public ModelAndView cancelAttachment(DocumentFormBase form) {
        form.setAttachmentFile(null);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView superUserTakeActions(DocumentFormBase form) {
        Set<String> selectedActionRequests;
        Document document = form.getDocument();
        String superUserAnnotation = document.getSuperUserAnnotation();
        if (StringUtils.isBlank((String)document.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserAnnotation", "superuser.takeactions.annotation.missing", new String[0]);
        }
        if (CollectionUtils.isEmpty(selectedActionRequests = form.getSelectedCollectionLines().get("document.actionRequests"))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserActionRequests", "superuser.takeactions.none.selected", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        ArrayList<ActionRequest> actionRequests = new ArrayList<ActionRequest>();
        for (String selectedActionRequest : selectedActionRequests) {
            ActionRequest actionRequest = (ActionRequest)ObjectPropertyUtils.getPropertyValue(document, selectedActionRequest);
            actionRequests.add(actionRequest);
        }
        for (ActionRequest actionRequest : actionRequests) {
            if (StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.COMPLETE.getCode()) || StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.APPROVE.getCode())) {
                document = this.getDocumentService().validateAndPersistDocument(document, new RouteDocumentEvent(document));
                document.setSuperUserAnnotation(superUserAnnotation);
                form.setDocument(document);
            }
            this.performSuperUserWorkflowAction(form, UifConstants.SuperUserWorkflowAction.TAKEACTION, actionRequest);
        }
        document.setSuperUserAnnotation("");
        form.getSelectedCollectionLines().remove("document.actionRequests");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView superUserApprove(DocumentFormBase form) {
        Set<String> selectedCollectionLines;
        Document document = form.getDocument();
        if (StringUtils.isBlank((String)document.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserAnnotation", "superuser.approve.annotation.missing", new String[0]);
        }
        if (!CollectionUtils.isEmpty(selectedCollectionLines = form.getSelectedCollectionLines().get("document.actionRequests"))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserActionRequests", "superuser.approve.when.actions.checked", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        this.performSuperUserWorkflowAction(form, UifConstants.SuperUserWorkflowAction.APPROVE);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView superUserDisapprove(DocumentFormBase form) {
        Set<String> selectedCollectionLines;
        Document document = form.getDocument();
        if (StringUtils.isBlank((String)document.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserAnnotation", "superuser.disapprove.annotation.missing", new String[0]);
        }
        if (!CollectionUtils.isEmpty(selectedCollectionLines = form.getSelectedCollectionLines().get("document.actionRequests"))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Uif-SuperUserActionRequests", "superuser.disapprove.when.actions.checked", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        this.performSuperUserWorkflowAction(form, UifConstants.SuperUserWorkflowAction.DISAPPROVE);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public void performWorkflowAction(DocumentFormBase form, UifConstants.WorkflowAction action) {
        this.performWorkflowAction(form, action, null);
    }

    @Override
    public void performWorkflowAction(DocumentFormBase form, UifConstants.WorkflowAction action, DocumentEvent documentEvent) {
        Document document = form.getDocument();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing workflow action " + action.name() + "for document: " + document.getDocumentNumber());
        }
        if (!UifConstants.WorkflowAction.SAVE.equals((Object)action) || document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            form.setEvaluateFlagsAndModes(true);
            form.setCanEditView(null);
        }
        try {
            String successMessageKey = null;
            switch (action) {
                case SAVE: {
                    document = documentEvent == null ? this.getDocumentService().saveDocument(document) : this.getDocumentService().saveDocument(document, documentEvent);
                    successMessageKey = "message.saved";
                    break;
                }
                case ROUTE: {
                    document = this.getDocumentService().routeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.successful";
                    break;
                }
                case BLANKETAPPROVE: {
                    document = this.getDocumentService().blanketApproveDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.approved";
                    break;
                }
                case APPROVE: {
                    document = this.getDocumentService().approveDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.approved";
                    break;
                }
                case DISAPPROVE: {
                    String disapprovalNoteText = this.generateDisapprovalNote(form);
                    document = this.getDocumentService().disapproveDocument(document, disapprovalNoteText);
                    successMessageKey = "message.route.disapproved";
                    break;
                }
                case FYI: {
                    document = this.getDocumentService().clearDocumentFyi(document, this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.fyied";
                    break;
                }
                case ACKNOWLEDGE: {
                    document = this.getDocumentService().acknowledgeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.acknowledged";
                    break;
                }
                case CANCEL: {
                    if (!this.getDocumentService().documentExists(document.getDocumentNumber())) break;
                    document = this.getDocumentService().cancelDocument(document, form.getAnnotation());
                    successMessageKey = "message.cancelled";
                    break;
                }
                case COMPLETE: {
                    if (!this.getDocumentService().documentExists(document.getDocumentNumber())) break;
                    document = this.getDocumentService().completeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.successful";
                    break;
                }
                case SENDADHOCREQUESTS: {
                    this.getDocumentService().sendAdHocRequests(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.successful";
                    break;
                }
                case RECALL: {
                    if (!this.getDocumentService().documentExists(document.getDocumentNumber())) break;
                    String recallExplanation = form.getDialogExplanations().get("ConfirmRecallDialog");
                    document = this.getDocumentService().recallDocument(document, recallExplanation, true);
                    successMessageKey = "message.route.recalled";
                }
            }
            form.setDocument(document);
            if (successMessageKey != null) {
                GlobalVariables.getMessageMap().putInfo("GlobalMessages", successMessageKey, new String[0]);
            }
        }
        catch (ValidationException e) {
            KRADUtils.logErrors();
            LOG.error("Validation Exception occurred for document :" + document.getDocumentNumber(), (Throwable)e);
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new RiceRuntimeException("Validation Exception with no error message.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Exception trying to invoke action " + action.name() + " for document: " + document.getDocumentNumber(), (Throwable)e);
        }
        form.setAnnotation("");
    }

    protected List<AdHocRouteRecipient> combineAdHocRecipients(DocumentFormBase form) {
        Document document = form.getDocument();
        ArrayList<AdHocRouteRecipient> adHocRecipients = new ArrayList<AdHocRouteRecipient>();
        adHocRecipients.addAll(document.getAdHocRoutePersons());
        adHocRecipients.addAll(document.getAdHocRouteWorkgroups());
        return adHocRecipients;
    }

    @Override
    public void performSuperUserWorkflowAction(DocumentFormBase form, UifConstants.SuperUserWorkflowAction action) {
        this.performSuperUserWorkflowAction(form, action, null);
    }

    @Override
    public void performSuperUserWorkflowAction(DocumentFormBase form, UifConstants.SuperUserWorkflowAction action, ActionRequest actionRequest) {
        Document document = form.getDocument();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing super user workflow action " + action.name() + "for document: " + document.getDocumentNumber());
        }
        try {
            String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
            String documentNumber = document.getDocumentNumber();
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String superUserAnnotation = document.getSuperUserAnnotation();
            WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentTypeId);
            DocumentActionParameters parameters = DocumentActionParameters.create((String)documentNumber, (String)principalId, (String)superUserAnnotation);
            String successMessageKey = null;
            switch (action) {
                case TAKEACTION: {
                    if (actionRequest == null) break;
                    documentActions.superUserTakeRequestedAction(parameters, true, actionRequest.getId());
                    String actionRequestedCode = actionRequest.getActionRequested().getCode();
                    if (StringUtils.equals((String)actionRequestedCode, (String)ActionRequestType.ACKNOWLEDGE.getCode())) {
                        successMessageKey = "general.routing.superuser.actionRequestAcknowledged";
                        break;
                    }
                    if (StringUtils.equals((String)actionRequestedCode, (String)ActionRequestType.FYI.getCode())) {
                        successMessageKey = "general.routing.superuser.actionRequestFYI";
                        break;
                    }
                    if (StringUtils.equals((String)actionRequestedCode, (String)ActionRequestType.COMPLETE.getCode())) {
                        successMessageKey = "general.routing.superuser.actionRequestCompleted";
                        break;
                    }
                    if (StringUtils.equals((String)actionRequestedCode, (String)ActionRequestType.APPROVE.getCode())) {
                        successMessageKey = "general.routing.superuser.actionRequestApproved";
                        break;
                    }
                    LOG.warn("Unknown action requested code: {}", (Object)actionRequestedCode);
                    successMessageKey = "general.routing.superuser.actionRequestApproved";
                    break;
                }
                case APPROVE: {
                    documentActions.superUserBlanketApprove(parameters, true);
                    successMessageKey = "general.routing.superuser.approved";
                    break;
                }
                case DISAPPROVE: {
                    documentActions.superUserDisapprove(parameters, true);
                    successMessageKey = "general.routing.superuser.disapproved";
                }
            }
            form.setEvaluateFlagsAndModes(true);
            form.setCanEditView(null);
            if (successMessageKey != null) {
                if (actionRequest != null) {
                    GlobalVariables.getMessageMap().putInfo("GlobalMessages", successMessageKey, new String[]{document.getDocumentNumber(), actionRequest.getId()});
                } else {
                    GlobalVariables.getMessageMap().putInfo("GlobalMessages", successMessageKey, new String[]{document.getDocumentNumber()});
                }
            }
        }
        catch (ValidationException e) {
            KRADUtils.logErrors();
            LOG.error("Validation Exception occurred for document :" + document.getDocumentNumber(), (Throwable)e);
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new RiceRuntimeException("Validation Exception with no error message.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Exception trying to invoke action " + action.name() + " for document: " + document.getDocumentNumber(), (Throwable)e);
        }
        document.setSuperUserAnnotation("");
    }

    protected WorkflowDocumentActionsService getWorkflowDocumentActionsService(String documentTypeId) {
        DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(documentTypeId);
        String applicationId = documentType.getApplicationId();
        QName serviceName = new QName("http://rice.kuali.org/kew/v2_0", "workflowDocumentActionsService");
        WorkflowDocumentActionsService service = (WorkflowDocumentActionsService)KsbApiServiceLocator.getServiceBus().getService(serviceName, applicationId);
        if (service == null) {
            service = KewApiServiceLocator.getWorkflowDocumentActionsService();
        }
        return service;
    }

    protected ModelAndView checkSensitiveDataAndWarningDialog(String field, UifFormBase form) {
        DialogResponse sensitiveDataDialogResponse;
        boolean hasSensitiveData = KRADUtils.containsSensitiveDataPatternMatch(field);
        Boolean warnForSensitiveData = this.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
        if (hasSensitiveData && warnForSensitiveData.booleanValue() && (sensitiveDataDialogResponse = form.getDialogResponse(SENSITIVE_DATA_DIALOG)) == null) {
            return this.getModelAndViewService().showDialog(SENSITIVE_DATA_DIALOG, true, form);
        }
        return null;
    }

    protected DocumentAuthorizationException buildAuthorizationException(String action, Document document) {
        return new DocumentAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), action, document.getDocumentNumber());
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
        }
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    protected AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = KRADServiceLocator.getAttachmentService();
        }
        return this.attachmentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    @Override
    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    @Override
    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    @Override
    protected NavigationControllerService getNavigationControllerService() {
        return this.navigationControllerService;
    }

    @Override
    public void setNavigationControllerService(NavigationControllerService navigationControllerService) {
        this.navigationControllerService = navigationControllerService;
    }

    protected ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

