/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.http.HttpMethod;

public class LookupForm
extends UifFormBase {
    private static final long serialVersionUID = -7323484966538685327L;
    @RequestAccessible
    private String dataObjectClassName;
    @RequestAccessible
    private boolean multipleValuesSelect;
    @RequestAccessible
    private boolean redirectedLookup;
    @RequestAccessible
    private boolean returnByScript;
    @RequestAccessible
    private String returnTarget;
    @RequestAccessible
    private String lookupCollectionName;
    @RequestAccessible
    private String lookupCollectionId;
    @RequestAccessible
    private String referencesToRefresh;
    @RequestAccessible
    private String quickfinderId;
    @RequestAccessible
    private Map<String, String> fieldConversions;
    private List<String> multiValueReturnFields;
    @RequestAccessible
    private Map<String, String> lookupCriteria;
    private Collection<?> lookupResults;
    @RequestAccessible
    private boolean displayResults;

    public LookupForm() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.lookupCriteria = new HashMap<String, String>();
        this.fieldConversions = new HashMap<String, String>();
        this.multiValueReturnFields = new ArrayList<String>();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        Lookupable lookupable;
        super.postBind(request);
        if (StringUtils.isBlank((String)this.getDataObjectClassName())) {
            this.setDataObjectClassName(((LookupView)this.getView()).getDataObjectClass().getName());
        }
        if ((lookupable = this.getLookupable()) != null) {
            Class<?> dataObjectClass;
            try {
                dataObjectClass = Class.forName(this.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Object class " + this.getDataObjectClassName() + " not found", e);
            }
            lookupable.setDataObjectClass(dataObjectClass);
        }
        if (request.getMethod().equals(HttpMethod.GET.name()) && request.getParameter("conversionFields") != null) {
            String conversionFields = request.getParameter("conversionFields");
            this.setFieldConversions(KRADUtils.convertStringParameterToMap(conversionFields));
        }
    }

    public Lookupable getLookupable() {
        if (this.getViewHelperService() != null) {
            return (Lookupable)this.getViewHelperService();
        }
        return null;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    public boolean isRedirectedLookup() {
        return this.redirectedLookup;
    }

    public void setRedirectedLookup(boolean redirectedLookup) {
        this.redirectedLookup = redirectedLookup;
    }

    public boolean isReturnByScript() {
        return this.returnByScript;
    }

    public void setReturnByScript(boolean returnByScript) {
        this.returnByScript = returnByScript;
    }

    public String getReturnTarget() {
        return this.returnTarget;
    }

    public void setReturnTarget(String returnTarget) {
        this.returnTarget = returnTarget;
    }

    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }

    public String getLookupCollectionId() {
        return this.lookupCollectionId;
    }

    public void setLookupCollectionId(String lookupCollectionId) {
        this.lookupCollectionId = lookupCollectionId;
    }

    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    public String getQuickfinderId() {
        return this.quickfinderId;
    }

    public void setQuickfinderId(String quickfinderId) {
        this.quickfinderId = quickfinderId;
    }

    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public List<String> getMultiValueReturnFields() {
        return this.multiValueReturnFields;
    }

    public void setMultiValueReturnFields(List<String> multiValueReturnFields) {
        this.multiValueReturnFields = multiValueReturnFields;
    }

    public Map<String, String> getLookupCriteria() {
        return this.lookupCriteria;
    }

    public void setLookupCriteria(Map<String, String> lookupCriteria) {
        this.lookupCriteria = lookupCriteria;
    }

    public Collection<?> getLookupResults() {
        return this.lookupResults;
    }

    public void setLookupResults(Collection<?> lookupResults) {
        this.lookupResults = lookupResults;
    }

    public boolean isDisplayResults() {
        return this.displayResults;
    }

    public void setDisplayResults(boolean displayResults) {
        this.displayResults = displayResults;
    }
}

