/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintenance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.maintenance.BulkUpdateMaintainable;
import org.kuali.rice.krad.maintenance.BulkUpdateMaintenanceDataObject;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class BulkUpdateMaintainableImpl
extends MaintainableImpl
implements BulkUpdateMaintainable {
    private static final long serialVersionUID = 6656390440709425848L;

    @Override
    public boolean isPersistable() {
        if (StringUtils.isBlank((String)this.getDocumentNumber())) {
            return false;
        }
        BulkUpdateMaintenanceDataObject dataObject = (BulkUpdateMaintenanceDataObject)this.getDataObject();
        List<?> targetUpdateDataObjects = dataObject.getTargetUpdateDataObjects();
        for (Object targetUpdateDataObject : targetUpdateDataObjects) {
            if (this.getLegacyDataAdapter().hasPrimaryKeyFieldValues(targetUpdateDataObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Object> generateUpdatableObjects() {
        ArrayList<Object> updatableObjects = new ArrayList<Object>();
        BulkUpdateMaintenanceDataObject bulkUpdateMaintenanceDataObject = (BulkUpdateMaintenanceDataObject)this.getDataObject();
        List<?> targetUpdateDataObjects = bulkUpdateMaintenanceDataObject.getTargetUpdateDataObjects();
        for (Object targetUpdateDataObject : targetUpdateDataObjects) {
            Map primaryKeys = this.getDataObjectService().wrap(targetUpdateDataObject).getPrimaryKeyValues();
            Object updatableObject = this.getDataObjectService().findUnique(targetUpdateDataObject.getClass(), QueryByCriteria.Builder.andAttributes((Map)primaryKeys).build());
            for (Map.Entry<String, ?> updateFieldValue : bulkUpdateMaintenanceDataObject.getUpdateFieldValues().entrySet()) {
                String propertyName = updateFieldValue.getKey();
                Object propertyValue = updateFieldValue.getValue();
                if (!ObjectPropertyUtils.isWritableProperty(updatableObject, propertyName)) continue;
                ObjectPropertyUtils.setPropertyValue(updatableObject, propertyName, propertyValue);
                updatableObjects.add(updatableObject);
            }
        }
        return updatableObjects;
    }

    @Override
    public List<MaintenanceLock> generateMaintenanceLocks() {
        List<MaintenanceLock> maintenanceLocks = super.generateMaintenanceLocks();
        BulkUpdateMaintenanceDataObject dataObject = (BulkUpdateMaintenanceDataObject)this.getDataObject();
        for (Object targetUpdateDataObjects : dataObject.getTargetUpdateDataObjects()) {
            String documentTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(targetUpdateDataObjects.getClass());
            maintenanceLocks.addAll(this.generateMaintenanceLocks(this.getDocumentNumber(), documentTypeName, targetUpdateDataObjects.getClass(), targetUpdateDataObjects));
        }
        return maintenanceLocks;
    }

    @Override
    public void saveDataObject() {
        for (Object updateableObject : this.generateUpdatableObjects()) {
            this.getLegacyDataAdapter().linkAndSave(updateableObject);
        }
    }
}

