/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.rules.rule.event;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.SaveDocumentRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;
import org.kuali.rice.krad.rules.rule.event.RuleEvent;
import org.kuali.rice.krad.rules.rule.event.SaveEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;

public class SaveDocumentEvent
extends DocumentEventBase
implements SaveEvent {
    public SaveDocumentEvent(String errorPathPrefix, Document document) {
        this("creating save event for document " + SaveDocumentEvent.getDocumentId(document), errorPathPrefix, document);
    }

    public SaveDocumentEvent(Document document) {
        this("", document);
    }

    public SaveDocumentEvent(String description, String errorPathPrefix, Document document) {
        super(description, errorPathPrefix, document);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return SaveDocumentRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((SaveDocumentRule)rule).processSaveDocument(this.document);
    }

    @Override
    public List<RuleEvent> generateEvents() {
        KualiRuleService ruleService = KRADServiceLocatorWeb.getKualiRuleService();
        ArrayList<RuleEvent> events = new ArrayList<RuleEvent>();
        events.addAll(ruleService.generateAdHocRoutePersonEvents(this.getDocument()));
        events.addAll(ruleService.generateAdHocRouteWorkgroupEvents(this.getDocument()));
        events.addAll(this.getDocument().generateSaveEvents());
        return events;
    }
}

