/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.KualiCode;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.DataFieldSecurity;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleAwareList;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.Help;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;
import org.kuali.rice.krad.web.form.InquiryForm;

@BeanTags(value={@BeanTag(name="data", parent="Uif-DataField"), @BeanTag(name="dataLabelTop", parent="Uif-DataField-LabelTop"), @BeanTag(name="dataLabelRight", parent="Uif-DataField-LabelRight"), @BeanTag(name="dataNoLabel", parent="Uif-DataField-withoutLabel")})
public class DataFieldBase
extends FieldBase
implements DataField {
    private static final long serialVersionUID = -4129678891948564724L;
    private String propertyName;
    private BindingInfo bindingInfo;
    private String dictionaryAttributeName;
    private String dictionaryObjectEntry;
    private Object defaultValue;
    private Class<? extends ValueFinder> defaultValueFinderClass;
    private List<Object> defaultValues;
    private String forcedValue;
    private PropertyEditor propertyEditor;
    private boolean addHiddenWhenReadOnly;
    protected String readOnlyDisplayReplacementPropertyName;
    protected String readOnlyDisplaySuffixPropertyName;
    private String readOnlyDisplayReplacement;
    private String readOnlyDisplaySuffix;
    private String readOnlyListDisplayType;
    private String readOnlyListDelimiter;
    private boolean applyMask;
    private MaskFormatter maskFormatter;
    private List<String> additionalHiddenPropertyNames = Collections.emptyList();
    private List<String> propertyNamesForAdditionalDisplay = Collections.emptyList();
    private boolean escapeHtmlInPropertyValue = true;
    private boolean multiLineReadOnlyDisplay;
    private Inquiry inquiry;
    private boolean enableAutoInquiry = true;
    private Help help;
    private boolean renderInfoMessageSpan;
    private boolean renderMarkerIconSpan;
    private String sortAs;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(ViewLifecycle.getView(), this.getPropertyName());
        }
    }

    @Override
    public void afterEvaluateExpression() {
        if (this.getReadOnly() == null) {
            this.setReadOnly(true);
        }
        super.afterEvaluateExpression();
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.enableAutoInquiry && this.inquiry == null && Boolean.TRUE.equals(this.getReadOnly()) && this.hasAutoInquiryRelationship()) {
            this.inquiry = ComponentFactory.getInquiry();
        }
        if (this.isAddHiddenWhenReadOnly()) {
            this.setReadOnly(true);
            this.getAdditionalHiddenPropertyNames().add(this.getPropertyName());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        boolean isReadOnlyList;
        super.performFinalize(model, parent);
        ArrayList<String> hiddenPropertyPaths = new ArrayList<String>();
        for (String string : this.getAdditionalHiddenPropertyNames()) {
            String hiddenPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(string);
            hiddenPropertyPaths.add(hiddenPropertyPath);
            if (!this.isRender() && !StringUtils.isNotBlank((String)this.getProgressiveRender())) continue;
            ViewLifecycle.getViewPostMetadata().addAccessibleBindingPath(hiddenPropertyPath);
        }
        this.additionalHiddenPropertyNames = hiddenPropertyPaths;
        ArrayList<String> informationalPropertyPaths = new ArrayList<String>();
        for (String infoPropertyName : this.getPropertyNamesForAdditionalDisplay()) {
            String infoPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(infoPropertyName);
            informationalPropertyPaths.add(infoPropertyPath);
        }
        this.propertyNamesForAdditionalDisplay = informationalPropertyPaths;
        boolean bl = this.getPropertyEditor() != null;
        boolean hasReadOnlyDisplayReplacement = StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacement());
        boolean hasReadOnlyDisplayReplacementPropertyName = StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacementPropertyName());
        String bindingPath = this.getBindingInfo().getBindingPath();
        Class<?> type = StringUtils.isNotEmpty((String)bindingPath) ? ObjectPropertyUtils.getPropertyType(model, bindingPath) : null;
        boolean bl2 = isReadOnlyList = Boolean.TRUE.equals(this.getReadOnly()) && type != null && List.class.isAssignableFrom(type);
        if (!bl && !hasReadOnlyDisplayReplacement && !hasReadOnlyDisplayReplacementPropertyName && isReadOnlyList) {
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, bindingPath);
            List list = fieldValue != null ? (List)fieldValue : Collections.emptyList();
            this.processReadOnlyListDisplay(model, list);
        } else {
            this.setAlternateAndAdditionalDisplayValue(ViewLifecycle.getView(), model);
        }
        if (this.getFieldLabel() != null && StringUtils.isNotBlank((String)this.getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getId() + "_control");
        }
        if (model instanceof ViewModel) {
            View view = ViewLifecycle.getView();
            if (((ViewModel)model).isApplyDefaultValues()) {
                view.getViewHelperService().populateDefaultValueForField(model, this, this.getBindingInfo().getBindingPath());
                ((ViewModel)model).setApplyDefaultValues(false);
            }
        }
        ViewPostMetadata viewPostMetadata = ViewLifecycle.getViewPostMetadata();
        if (this.isRender() && viewPostMetadata != null) {
            viewPostMetadata.addRenderedPropertyPath(this.getBindingInfo().getBindingPath());
        }
    }

    protected void processReadOnlyListDisplay(Object model, List<?> originalList) {
        this.setReadOnlyDisplayReplacement(this.generateReadOnlyListDisplayReplacement(originalList));
    }

    protected String generateReadOnlyListDisplayReplacement(List<?> list) {
        if (this.getReadOnlyListDisplayType() == null) {
            this.setReadOnlyListDisplayType(UifConstants.ReadOnlyListTypes.DELIMITED.name());
        }
        Object generatedHtml = "";
        if (!list.isEmpty()) {
            if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name())) {
                generatedHtml = "<ul class='uif-readOnlyStringList'>";
            } else if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name())) {
                generatedHtml = "<ol class='uif-readOnlyStringList'>";
            } else if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.BREAK.name())) {
                this.setReadOnlyListDelimiter("<br/>");
            } else if (this.getReadOnlyListDelimiter() == null) {
                this.setReadOnlyListDelimiter(", ");
            }
        }
        for (Object value : list) {
            if (!TypeUtils.isSimpleType(value.getClass()) || StringUtils.isBlank((String)value.toString())) continue;
            if (this.isApplyMask()) {
                value = this.getMaskFormatter().maskValue(value);
            }
            if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name()) || this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name())) {
                generatedHtml = (String)generatedHtml + "<li>" + StringEscapeUtils.escapeHtml((String)value.toString()) + "</li>";
                continue;
            }
            generatedHtml = (String)generatedHtml + StringEscapeUtils.escapeHtml((String)value.toString()) + this.getReadOnlyListDelimiter();
        }
        if (!list.isEmpty()) {
            generatedHtml = this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name()) ? (String)generatedHtml + "</ul>" : (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name()) ? (String)generatedHtml + "</ol>" : StringUtils.removeEnd((String)generatedHtml, (String)this.getReadOnlyListDelimiter()));
        }
        if (StringUtils.isBlank((String)generatedHtml)) {
            generatedHtml = "&nbsp;";
        }
        return generatedHtml;
    }

    protected void setAlternateAndAdditionalDisplayValue(View view, Object model) {
        String additionalDisplayPropertyPath;
        Object additionalFieldValue;
        String alternateDisplayPropertyPath;
        Object alternateFieldValue;
        if (StringUtils.isNotBlank((String)this.readOnlyDisplayReplacement) || StringUtils.isNotBlank((String)this.readOnlyDisplaySuffix)) {
            return;
        }
        if (this.isApplyMask()) {
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
            if (this.getMaskFormatter() != null) {
                this.readOnlyDisplayReplacement = this.getMaskFormatter().maskValue(fieldValue);
            }
            return;
        }
        if (!Boolean.TRUE.equals(this.getReadOnly())) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacementPropertyName()) && (alternateFieldValue = ObjectPropertyUtils.getPropertyValue(model, alternateDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getReadOnlyDisplayReplacementPropertyName()))) != null) {
            this.readOnlyDisplayReplacement = alternateFieldValue.toString();
        }
        if (StringUtils.isBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && view.isTranslateCodesOnReadOnlyDisplay()) {
            Class<?> parentObjectClass = ViewModelUtils.getParentObjectClassForMetadata(view, model, this);
            DataObjectRelationship relationship = KRADServiceLocatorWeb.getLegacyDataAdapter().getDataObjectRelationship(null, parentObjectClass, this.getBindingInfo().getBindingName(), "", true, false, false);
            if (relationship != null && this.getPropertyName().startsWith(relationship.getParentAttributeName()) && KualiCode.class.isAssignableFrom(relationship.getRelatedClass())) {
                this.readOnlyDisplaySuffixPropertyName = relationship.getParentAttributeName() + ".name";
            }
        }
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && (additionalFieldValue = ObjectPropertyUtils.getPropertyValue(model, additionalDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getReadOnlyDisplaySuffixPropertyName()))) != null) {
            this.readOnlyDisplaySuffix = additionalFieldValue.toString();
        }
    }

    @Override
    public void copyFromAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (attributeDefinition.getAttributeSecurity() != null && (this.getDataFieldSecurity() == null || this.getDataFieldSecurity().getAttributeSecurity() == null)) {
            this.initializeComponentSecurity();
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getReadOnlyDisplayReplacementPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAlternateDisplayAttributeName())) {
            this.setReadOnlyDisplayReplacementPropertyName(attributeDefinition.getAlternateDisplayAttributeName());
        }
        if (this.getReadOnlyDisplaySuffixPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAdditionalDisplayAttributeName())) {
            this.setReadOnlyDisplaySuffixPropertyName(attributeDefinition.getAdditionalDisplayAttributeName());
        }
        if (this.getPropertyEditor() == null) {
            this.setPropertyEditor(attributeDefinition.getPropertyEditor());
        }
    }

    @Override
    public boolean isInputAllowed() {
        return false;
    }

    @Override
    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute
    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    @Override
    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    @Override
    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = KRADUtils.createNewObjectFromClass(propertyEditorClass);
    }

    @Override
    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    @Override
    public String getName() {
        return this.getBindingInfo().getBindingPath();
    }

    @Override
    @BeanTagAttribute
    public String getDictionaryAttributeName() {
        return this.dictionaryAttributeName;
    }

    @Override
    public void setDictionaryAttributeName(String dictionaryAttributeName) {
        this.dictionaryAttributeName = dictionaryAttributeName;
    }

    @Override
    @BeanTagAttribute
    public String getDictionaryObjectEntry() {
        return this.dictionaryObjectEntry;
    }

    @Override
    public void setDictionaryObjectEntry(String dictionaryObjectEntry) {
        this.dictionaryObjectEntry = dictionaryObjectEntry;
    }

    @Override
    @BeanTagAttribute
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @BeanTagAttribute
    public Class<? extends ValueFinder> getDefaultValueFinderClass() {
        return this.defaultValueFinderClass;
    }

    @Override
    public void setDefaultValueFinderClass(Class<? extends ValueFinder> defaultValueFinderClass) {
        this.defaultValueFinderClass = defaultValueFinderClass;
    }

    @Override
    @BeanTagAttribute
    public List<Object> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public void setDefaultValues(List<Object> defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Override
    public String getForcedValue() {
        return this.forcedValue;
    }

    @Override
    public void setForcedValue(String forcedValue) {
        this.forcedValue = forcedValue;
    }

    @Override
    @BeanTagAttribute
    public String getHelpSummary() {
        return this.help.getTooltipHelpContent();
    }

    @Override
    public void setHelpSummary(String helpSummary) {
        this.help.setTooltipHelpContent(helpSummary);
    }

    @Override
    public DataFieldSecurity getDataFieldSecurity() {
        return (DataFieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof DataFieldSecurity)) {
            throw new RiceRuntimeException("Component security for DataField should be instance of DataFieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected void initializeComponentSecurity() {
        if (this.getComponentSecurity() == null) {
            this.setComponentSecurity(KRADUtils.createNewObjectFromClass(DataFieldSecurity.class));
        }
    }

    @Override
    @BeanTagAttribute
    public boolean isAddHiddenWhenReadOnly() {
        return this.addHiddenWhenReadOnly;
    }

    @Override
    public void setAddHiddenWhenReadOnly(boolean addHiddenWhenReadOnly) {
        this.addHiddenWhenReadOnly = addHiddenWhenReadOnly;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Inquiry getInquiry() {
        return this.inquiry;
    }

    @Override
    public void setInquiry(Inquiry inquiry) {
        this.inquiry = inquiry;
    }

    @Override
    public boolean isEnableAutoInquiry() {
        return this.enableAutoInquiry;
    }

    @Override
    public void setEnableAutoInquiry(boolean enableAutoInquiry) {
        this.enableAutoInquiry = enableAutoInquiry;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Help getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(Help help) {
        this.help = help;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderInfoMessageSpan() {
        return this.renderInfoMessageSpan;
    }

    @Override
    public void setRenderInfoMessageSpan(boolean renderInfoMessageSpan) {
        this.renderInfoMessageSpan = renderInfoMessageSpan;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderMarkerIconSpan() {
        return this.renderMarkerIconSpan;
    }

    @Override
    public void setRenderMarkerIconSpan(boolean renderMarkerIconSpan) {
        this.renderMarkerIconSpan = renderMarkerIconSpan;
    }

    @Override
    public void setTooltipOfComponent(Tooltip tooltip) {
        this.getFieldLabel().setToolTip(tooltip);
    }

    @Override
    public String getHelpTitle() {
        return this.getLabel();
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyDisplaySuffixPropertyName() {
        return this.readOnlyDisplaySuffixPropertyName;
    }

    @Override
    public void setReadOnlyDisplaySuffixPropertyName(String readOnlyDisplaySuffixPropertyName) {
        this.readOnlyDisplaySuffixPropertyName = readOnlyDisplaySuffixPropertyName;
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyDisplayReplacementPropertyName() {
        return this.readOnlyDisplayReplacementPropertyName;
    }

    @Override
    public void setReadOnlyDisplayReplacementPropertyName(String readOnlyDisplayReplacementPropertyName) {
        this.readOnlyDisplayReplacementPropertyName = readOnlyDisplayReplacementPropertyName;
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyDisplayReplacement() {
        return this.readOnlyDisplayReplacement;
    }

    @Override
    public void setReadOnlyDisplayReplacement(String value) {
        this.readOnlyDisplayReplacement = value;
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyDisplaySuffix() {
        return this.readOnlyDisplaySuffix;
    }

    @Override
    public void setReadOnlyDisplaySuffix(String value) {
        this.readOnlyDisplaySuffix = value;
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyListDisplayType() {
        return this.readOnlyListDisplayType;
    }

    @Override
    public void setReadOnlyListDisplayType(String readOnlyListDisplayType) {
        this.readOnlyListDisplayType = readOnlyListDisplayType;
    }

    @Override
    @BeanTagAttribute
    public String getReadOnlyListDelimiter() {
        return this.readOnlyListDelimiter;
    }

    @Override
    public void setReadOnlyListDelimiter(String readOnlyListDelimiter) {
        this.readOnlyListDelimiter = readOnlyListDelimiter;
    }

    @Override
    @BeanTagAttribute
    public boolean isApplyMask() {
        return this.applyMask;
    }

    @Override
    public void setApplyMask(boolean applyMask) {
        this.applyMask = applyMask;
    }

    @Override
    @BeanTagAttribute
    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    @Override
    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    @Override
    @BeanTagAttribute
    public List<String> getAdditionalHiddenPropertyNames() {
        if (this.additionalHiddenPropertyNames == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.additionalHiddenPropertyNames = new LifecycleAwareList<String>(this);
        }
        return this.additionalHiddenPropertyNames;
    }

    @Override
    public void setAdditionalHiddenPropertyNames(List<String> additionalHiddenPropertyNames) {
        this.additionalHiddenPropertyNames = additionalHiddenPropertyNames == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, additionalHiddenPropertyNames);
    }

    @Override
    @BeanTagAttribute
    public List<String> getPropertyNamesForAdditionalDisplay() {
        if (this.propertyNamesForAdditionalDisplay == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.propertyNamesForAdditionalDisplay = new LifecycleAwareList<String>(this);
        }
        return this.propertyNamesForAdditionalDisplay;
    }

    @Override
    public void setPropertyNamesForAdditionalDisplay(List<String> propertyNamesForAdditionalDisplay) {
        this.propertyNamesForAdditionalDisplay = propertyNamesForAdditionalDisplay == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, propertyNamesForAdditionalDisplay);
    }

    @Override
    @BeanTagAttribute
    public boolean isEscapeHtmlInPropertyValue() {
        return this.escapeHtmlInPropertyValue;
    }

    @Override
    public void setEscapeHtmlInPropertyValue(boolean escapeHtmlInPropertyValue) {
        this.escapeHtmlInPropertyValue = escapeHtmlInPropertyValue;
    }

    @Override
    @BeanTagAttribute
    public boolean isMultiLineReadOnlyDisplay() {
        return this.multiLineReadOnlyDisplay;
    }

    @Override
    public void setMultiLineReadOnlyDisplay(boolean multiLineReadOnlyDisplay) {
        this.multiLineReadOnlyDisplay = multiLineReadOnlyDisplay;
    }

    @Override
    public boolean hasSecureValue() {
        boolean hasHideAuthz = false;
        if (this.getDataFieldSecurity() != null) {
            boolean isViewAuthz = false;
            boolean isViewInLineAuthz = false;
            boolean isHide = false;
            if (this.getDataFieldSecurity().isViewAuthz() != null) {
                isViewAuthz = this.getDataFieldSecurity().isViewAuthz();
            }
            if (this.getDataFieldSecurity().isViewInLineAuthz() != null) {
                isViewInLineAuthz = this.getDataFieldSecurity().isViewInLineAuthz();
            }
            if (this.getDataFieldSecurity().getAttributeSecurity() != null) {
                isHide = this.getDataFieldSecurity().getAttributeSecurity().isHide();
            }
            hasHideAuthz = isViewAuthz || isViewInLineAuthz || isHide;
        }
        return this.isApplyMask() || hasHideAuthz && this.isHidden();
    }

    @Override
    public boolean isRenderFieldset() {
        return !Boolean.TRUE.equals(this.getReadOnly()) && this.inquiry != null && this.inquiry.isRender() && this.inquiry.getInquiryLink() != null && this.inquiry.getInquiryLink().isRender() || this.help != null && this.help.isRender() && this.help.getHelpAction() != null && this.help.getHelpAction().isRender();
    }

    @Override
    @BeanTagAttribute(name="sortAs")
    public String getSortAs() {
        return this.sortAs;
    }

    @Override
    public void setSortAs(String sortAs) {
        if (!(sortAs.equals("kuali_currency") || sortAs.equals("kuali_date") || sortAs.equals("numeric") || sortAs.equals("string"))) {
            throw new IllegalArgumentException("invalid sortAs value of " + sortAs + ", allowed: kuali_currency|kuali_date|numeric|string");
        }
        this.sortAs = sortAs;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getPropertyName() == null && !Validator.checkExpressions(this, "propertyName")) {
            currentValues = new String[]{"propertyName = " + this.getPropertyName()};
            tracer.createError("Property name not set", currentValues);
        }
        if (this.isApplyMask() && this.maskFormatter == null) {
            currentValues = new String[]{"applyMask =" + this.isApplyMask(), "maskFormatter =" + String.valueOf(this.maskFormatter)};
            tracer.createWarning("Apply mask is true, but no value is set for maskFormatter", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    protected boolean hasAutoInquiryRelationship() {
        if (this.getBindingInfo() == null) {
            return false;
        }
        View view = ViewLifecycle.getView();
        Object model = ViewLifecycle.getModel();
        Object object = ViewModelUtils.getParentObjectForMetadata(view, model, this);
        if (Boolean.TRUE.equals(this.getReadOnly())) {
            Object propertyValue;
            String bindingPath = this.getBindingInfo().getBindingPath();
            if (StringUtils.isBlank((String)bindingPath) || bindingPath.equals("null")) {
                return false;
            }
            try {
                propertyValue = ObjectPropertyUtils.getPropertyValue(model, bindingPath);
                if (propertyValue == null || StringUtils.isBlank((String)propertyValue.toString())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (view.getViewTypeName() == UifConstants.ViewType.INQUIRY) {
                InquiryForm inquiryForm = (InquiryForm)model;
                Object[] parameterValues = inquiryForm.getInitialRequestParameters().get(this.propertyName);
                if (StringUtils.equals((String)inquiryForm.getDataObjectClassName(), (String)this.dictionaryObjectEntry) && ArrayUtils.contains((Object[])parameterValues, (Object)propertyValue.toString())) {
                    return false;
                }
            }
        }
        return object != null && KRADServiceLocatorWeb.getViewDictionaryService().isInquirable(object.getClass());
    }
}

