/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.core.Environment;
import freemarker.core.Macro;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerInlineRenderUtils;
import org.kuali.rice.krad.uif.freemarker.LifecycleRenderingContext;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;

public class RenderComponentTask
extends ViewLifecycleTaskBase<Component> {
    private static final Logger LOG = LogManager.getLogger(RenderComponentTask.class);

    public RenderComponentTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        block7: {
            Component component = (Component)this.getElementState().getElement();
            if (!component.isRender() || component.getTemplate() == null) {
                return;
            }
            LifecycleRenderingContext renderingContext = ViewLifecycle.getRenderingContext();
            renderingContext.clearRenderingBuffer();
            renderingContext.importTemplate(component.getTemplate());
            for (String additionalTemplate : component.getAdditionalTemplates()) {
                renderingContext.importTemplate(additionalTemplate);
            }
            try {
                Environment env = renderingContext.getEnvironment();
                Macro fmMacro = (Macro)env.getMainNamespace().get(component.getTemplateName());
                if (fmMacro == null) {
                    return;
                }
                String[] args = fmMacro.getArgumentNames();
                if (args == null || args.length != 1 || !component.getComponentTypeName().equals(args[0])) {
                    return;
                }
                FreeMarkerInlineRenderUtils.renderTemplate(env, component, null, false, false, Collections.emptyMap());
                component.setRenderedHtmlOutput(renderingContext.getRenderedOutput());
                component.setSelfRendered(true);
            }
            catch (Throwable e) {
                if (ViewLifecycle.isStrict()) {
                    LOG.warn("Error rendering component during lifecycle phase " + String.valueOf(this.getElementState()) + " falling back to higher level rendering", e);
                }
                if (!ViewLifecycle.isTrace() || !LOG.isDebugEnabled()) break block7;
                LOG.debug("component rendering failed during lifecycle phase " + String.valueOf(this.getElementState()) + " falling back to higher level rendering", e);
            }
        }
    }
}

