/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.layout.CssGridSizes;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;

@BeanTag(name="cssGridLayoutBase", parent="Uif-CssGridLayoutBase")
public abstract class CssGridLayoutManagerBase
extends LayoutManagerBase {
    private static final long serialVersionUID = 1830635073147703757L;
    protected static final int NUMBER_OF_COLUMNS = 12;
    protected static final String BOOTSTRAP_SPAN_PREFIX = "col-md-";
    protected List<Component> cellItems;
    protected List<String> cellCssClassAttributes = new ArrayList<String>();
    protected int xsTotalSize = 0;
    protected int smTotalSize = 0;
    protected int mdTotalSize = 0;
    protected int lgTotalSize = 0;

    public CssGridLayoutManagerBase() {
        this.cellItems = new ArrayList<Component>();
    }

    protected void calculateCssClassAndSize(Component item, List<String> cellCssClasses, CssGridSizes defaultSizes, int basicSize) {
        if (StringUtils.isNotBlank((String)item.getCssGridSizes().getCssClassString())) {
            cellCssClasses.add(0, item.getCssGridSizes().getCssClassString());
            this.xsTotalSize += item.getCssGridSizes().getXsSize();
            this.smTotalSize += item.getCssGridSizes().getTotalSmSize();
            this.mdTotalSize += item.getCssGridSizes().getTotalMdSize();
            this.lgTotalSize += item.getCssGridSizes().getTotalLgSize();
        } else if (StringUtils.isNotBlank((String)defaultSizes.getCssClassString())) {
            cellCssClasses.add(0, defaultSizes.getCssClassString());
            this.xsTotalSize += defaultSizes.getXsSize();
            this.smTotalSize += defaultSizes.getTotalSmSize();
            this.mdTotalSize += defaultSizes.getTotalMdSize();
            this.lgTotalSize += defaultSizes.getTotalLgSize();
        } else {
            cellCssClasses.add(0, BOOTSTRAP_SPAN_PREFIX + basicSize);
            this.mdTotalSize += basicSize;
        }
    }

    protected void addLeftClearCssClass(List<String> cellCssClasses) {
        String classString = this.getCellStyleClassesAsString(cellCssClasses);
        if (this.lgTotalSize > 12) {
            if (classString.contains("col-lg-")) {
                cellCssClasses.add(0, "lg-clear-left");
            }
            this.lgTotalSize -= 12;
        }
        if (this.mdTotalSize > 12) {
            if (classString.contains(BOOTSTRAP_SPAN_PREFIX)) {
                cellCssClasses.add(0, "md-clear-left");
            }
            this.mdTotalSize -= 12;
        }
        if (this.smTotalSize > 12) {
            if (classString.contains("col-sm-")) {
                cellCssClasses.add(0, "sm-clear-left");
            }
            this.smTotalSize -= 12;
        }
        if (this.xsTotalSize > 12) {
            cellCssClasses.add(0, "xs-clear-left");
            this.xsTotalSize -= 12;
        }
    }

    protected String getCellStyleClassesAsString(List<String> cellCssClasses) {
        if (cellCssClasses != null) {
            return StringUtils.join(cellCssClasses, (String)" ").trim();
        }
        return "";
    }

    @ViewLifecycleRestriction
    public List<Component> getCellItems() {
        return this.cellItems;
    }

    public List<String> getCellCssClassAttributes() {
        return this.cellCssClassAttributes;
    }
}

