/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ObjectPathExpressionParser;
import org.kuali.rice.krad.uif.util.ObjectPropertyReference;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public final class ObjectPropertyUtils {
    private static final Logger LOG = LogManager.getLogger(ObjectPropertyUtils.class);
    private static final Map<Class<?>, ObjectPropertyMetadata> METADATA_CACHE = Collections.synchronizedMap(new WeakHashMap(2048));
    private static final SplitPropertyPathEntry SPLIT_PROPERTY_PATH_ENTRY = new SplitPropertyPathEntry();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass) {
        return ObjectPropertyUtils.getMetadata(beanClass).propertyDescriptors;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        PropertyDescriptor propertyDescriptor = ObjectPropertyUtils.getPropertyDescriptors(beanClass).get(propertyName);
        if (propertyDescriptor != null) {
            return propertyDescriptor;
        }
        throw new IllegalArgumentException("Property " + propertyName + " not found for bean " + String.valueOf(beanClass));
    }

    public static void registerPropertyEditors(PropertyEditorRegistry registry) {
        DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        Map<Class<?>, String> propertyEditorMap = dataDictionaryService.getPropertyEditorMap();
        if (propertyEditorMap == null) {
            LOG.warn("No propertyEditorMap defined in data dictionary");
            return;
        }
        for (Map.Entry<Class<?>, String> propertyEditorEntry : propertyEditorMap.entrySet()) {
            PropertyEditor editor = (PropertyEditor)dataDictionaryService.getDataDictionary().getDictionaryPrototype(propertyEditorEntry.getValue());
            registry.registerCustomEditor(propertyEditorEntry.getKey(), editor);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("registered " + String.valueOf(propertyEditorEntry));
        }
    }

    public static Set<String> getReadablePropertyNames(Class<?> beanClass) {
        return ObjectPropertyUtils.getMetadata(beanClass).readMethods.keySet();
    }

    public static Method getReadMethod(Class<?> beanClass, String propertyName) {
        return ObjectPropertyUtils.getMetadata(beanClass).readMethods.get(propertyName);
    }

    public static Method getWriteMethod(Class<?> beanClass, String propertyName) {
        return ObjectPropertyUtils.getMetadata(beanClass).writeMethods.get(propertyName);
    }

    public static void copyPropertiesToObject(Map<String, String> properties, Object object) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            ObjectPropertyUtils.setPropertyValue(object, property.getKey(), property.getValue());
        }
    }

    public static Class<?> getPropertyType(Class<?> beanClass, String propertyPath) {
        try {
            ObjectPropertyReference.setWarning(true);
            Class<?> clazz = ObjectPropertyReference.resolvePath(null, beanClass, propertyPath, false).getPropertyType();
            return clazz;
        }
        finally {
            ObjectPropertyReference.setWarning(false);
        }
    }

    public static Class<?> getPropertyType(Object object, String propertyPath) {
        try {
            ObjectPropertyReference.setWarning(true);
            Class<?> clazz = ObjectPropertyReference.resolvePath(object, object.getClass(), propertyPath, false).getPropertyType();
            return clazz;
        }
        finally {
            ObjectPropertyReference.setWarning(false);
        }
    }

    public static Set<String> getReadablePropertyNamesByType(Object bean, Class<?> propertyType) {
        return ObjectPropertyUtils.getReadablePropertyNamesByType(bean.getClass(), propertyType);
    }

    public static Set<String> getReadablePropertyNamesByType(Class<?> beanClass, Class<?> propertyType) {
        return ObjectPropertyUtils.getMetadata(beanClass).getReadablePropertyNamesByType(propertyType);
    }

    public static Set<String> getReadablePropertyNamesByAnnotationType(Object bean, Class<? extends Annotation> annotationType) {
        return ObjectPropertyUtils.getReadablePropertyNamesByAnnotationType(bean.getClass(), annotationType);
    }

    public static Set<String> getReadablePropertyNamesByAnnotationType(Class<?> beanClass, Class<? extends Annotation> annotationType) {
        return ObjectPropertyUtils.getMetadata(beanClass).getReadablePropertyNamesByAnnotationType(annotationType);
    }

    public static Set<String> getReadablePropertyNamesByCollectionType(Object bean, Class<?> collectionType) {
        return ObjectPropertyUtils.getReadablePropertyNamesByCollectionType(bean.getClass(), collectionType);
    }

    public static Set<String> getWritablePropertyNames(Object bean) {
        return ObjectPropertyUtils.getMetadata(bean.getClass()).getWritablePropertyNames();
    }

    public static Set<String> getReadablePropertyNamesByCollectionType(Class<?> beanClass, Class<?> collectionType) {
        return ObjectPropertyUtils.getMetadata(beanClass).getReadablePropertyNamesByCollectionType(collectionType);
    }

    public static <T> T getPropertyValue(Object object, String propertyPath) {
        boolean trace;
        boolean bl = trace = ProcessLogger.isTraceActive() && object != null;
        if (trace) {
            ProcessLogger.countBegin("bean-property-read");
        }
        try {
            ObjectPropertyReference.setWarning(true);
            Object object2 = ObjectPropertyReference.resolvePath(object, object.getClass(), propertyPath, false).get();
            return (T)object2;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error getting property '" + propertyPath + "' from " + String.valueOf(object), e);
        }
        finally {
            ObjectPropertyReference.setWarning(false);
            if (trace) {
                ProcessLogger.countEnd("bean-property-read", object.getClass().getSimpleName() + ":" + propertyPath);
            }
        }
    }

    public static String getPropertyValueAsText(Object bean, String path) {
        Object propertyValue = ObjectPropertyUtils.getPropertyValue(bean, path);
        PropertyEditor editor = ObjectPropertyUtils.getPropertyEditor(bean, path);
        if (editor == null) {
            return propertyValue == null ? null : propertyValue.toString();
        }
        editor.setValue(propertyValue);
        return editor.getAsText();
    }

    public static PropertyEditorRegistry getPropertyEditorRegistry() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        PropertyEditorRegistry registry = null;
        if (attributes != null) {
            registry = (PropertyEditorRegistry)attributes.getAttribute("rice.krad.uif.propertyEditorRegistry", 0);
        }
        return registry;
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        if (Byte.class.equals(type)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(type)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(type)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type)) {
            return Long.TYPE;
        }
        if (Boolean.class.equals(type)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals(type)) {
            return Float.TYPE;
        }
        if (Double.class.equals(type)) {
            return Double.TYPE;
        }
        return type;
    }

    public static PropertyEditor getPropertyEditor(Object bean, String path) {
        Class<?> propertyType = ObjectPropertyUtils.getPrimitiveType(ObjectPropertyUtils.getPropertyType(bean, path));
        PropertyEditor editor = null;
        PropertyEditorRegistry registry = ObjectPropertyUtils.getPropertyEditorRegistry();
        if (registry != null) {
            editor = registry.findCustomEditor(propertyType, path);
            if (editor != null && editor != registry.findCustomEditor(propertyType, null)) {
                return editor;
            }
            if (registry instanceof BeanWrapper && bean == ((BeanWrapper)registry).getWrappedInstance() && bean instanceof ViewModel) {
                PropertyEditor editorFromView;
                ViewModel viewModel = (ViewModel)bean;
                ViewPostMetadata viewPostMetadata = viewModel.getViewPostMetadata();
                PropertyEditor propertyEditor = editorFromView = viewPostMetadata == null ? null : viewPostMetadata.getFieldEditor(path);
                if (editorFromView != null) {
                    registry.registerCustomEditor(propertyType, path, editorFromView);
                    editor = registry.findCustomEditor(propertyType, path);
                }
            }
        }
        if (editor != null) {
            return editor;
        }
        return ObjectPropertyUtils.getPropertyEditor(propertyType);
    }

    public static PropertyEditor getPropertyEditor(Class<?> propertyType) {
        PropertyEditorRegistry registry = ObjectPropertyUtils.getPropertyEditorRegistry();
        PropertyEditor editor = null;
        if (registry != null) {
            editor = registry.findCustomEditor(propertyType, null);
        } else {
            String editorPrototypeName;
            DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
            Map<Class<?>, String> editorMap = dataDictionaryService.getPropertyEditorMap();
            String string = editorPrototypeName = editorMap == null ? null : editorMap.get(propertyType);
            if (editorPrototypeName != null) {
                editor = (PropertyEditor)dataDictionaryService.getDataDictionary().getDictionaryPrototype(editorPrototypeName);
            }
        }
        if (editor == null && propertyType != null) {
            editor = PropertyEditorManager.findEditor(propertyType);
        }
        return editor;
    }

    public static void initializeProperty(Object object, String propertyPath) {
        Class<?> propertyType = ObjectPropertyUtils.getPropertyType(object, propertyPath);
        try {
            ObjectPropertyUtils.setPropertyValue(object, propertyPath, propertyType.newInstance());
        }
        catch (InstantiationException e) {
            ObjectPropertyUtils.setPropertyValue(object, propertyPath, null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to set new instance for property: " + propertyPath, e);
        }
    }

    public static void setPropertyValue(Object object, String propertyPath, Object propertyValue) {
        if (ProcessLogger.isTraceActive() && object != null) {
            ProcessLogger.countBegin("bean-property-write");
        }
        try {
            ObjectPropertyReference.setWarning(true);
            ObjectPropertyReference.resolvePath(object, object.getClass(), propertyPath, true).set(propertyValue);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error setting property '" + propertyPath + "' on " + String.valueOf(object) + " with " + String.valueOf(propertyValue), e);
        }
        finally {
            ObjectPropertyReference.setWarning(false);
            if (ProcessLogger.isTraceActive() && object != null) {
                ProcessLogger.countEnd("bean-property-write", object.getClass().getSimpleName() + ":" + propertyPath);
            }
        }
    }

    public static void setPropertyValue(Object object, String propertyPath, Object propertyValue, boolean ignoreUnknown) {
        block3: {
            try {
                ObjectPropertyUtils.setPropertyValue(object, propertyPath, propertyValue);
            }
            catch (RuntimeException e) {
                if (!ignoreUnknown) {
                    throw e;
                }
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace("Ignoring exception thrown during setting of property '" + propertyPath + "': " + e.getLocalizedMessage());
            }
        }
    }

    public static boolean isReadableProperty(Object object, String propertyPath) {
        return ObjectPropertyReference.resolvePath(object, object.getClass(), propertyPath, false).canRead();
    }

    public static boolean isWritableProperty(Object object, String propertyPath) {
        return ObjectPropertyReference.resolvePath(object, object.getClass(), propertyPath, false).canWrite();
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type, Class<?> stopAt) {
        for (Field field : type.getDeclaredFields()) {
            fields.add(field);
        }
        if (type.getSuperclass() != null && !type.getName().equals(stopAt.getName())) {
            fields = ObjectPropertyUtils.getAllFields(fields, type.getSuperclass(), stopAt);
        }
        return fields;
    }

    public static Type getComponentType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] params = parameterizedType.getActualTypeArguments();
        if (params.length == 0) {
            return Object.class;
        }
        Type valueType = params[params.length - 1];
        return valueType;
    }

    public static Class<?> getUpperBound(Type valueType) {
        Type[] upperBounds;
        if (valueType instanceof WildcardType && (upperBounds = ((WildcardType)valueType).getUpperBounds()).length >= 1) {
            valueType = upperBounds[0];
        }
        if (valueType instanceof ParameterizedType) {
            valueType = ((ParameterizedType)valueType).getRawType();
        }
        if (valueType instanceof Class) {
            return (Class)valueType;
        }
        return Object.class;
    }

    public static Type findGenericType(Class<?> sourceClass, Class<?> targetClass) {
        if (!targetClass.isAssignableFrom(sourceClass)) {
            throw new IllegalArgumentException(String.valueOf(targetClass) + " is not assignable from " + String.valueOf(sourceClass));
        }
        if (sourceClass.equals(targetClass)) {
            return sourceClass;
        }
        Queue typeQueue = RecycleUtils.getInstance(LinkedList.class);
        typeQueue.offer(sourceClass);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.poll();
            Class<?> upperBound = ObjectPropertyUtils.getUpperBound(type);
            if (targetClass.equals(upperBound)) {
                return type;
            }
            Type genericSuper = upperBound.getGenericSuperclass();
            if (genericSuper != null) {
                typeQueue.offer(genericSuper);
            }
            Type[] genericInterfaces = upperBound.getGenericInterfaces();
            for (int i = 0; i < genericInterfaces.length; ++i) {
                if (genericInterfaces[i] == null) continue;
                typeQueue.offer(genericInterfaces[i]);
            }
        }
        throw new IllegalStateException(String.valueOf(targetClass) + " is assignable from " + String.valueOf(sourceClass) + " but could not be found in the generic type hierarchy");
    }

    private static void rejoinTrailingIndexReference(List<String> tokenList, String path) {
        String lastParentToken;
        int lastIndex = tokenList.size() - 1;
        String lastToken = tokenList.get(lastIndex);
        if (!lastToken.equals(lastParentToken = path.substring(path.lastIndexOf(46) + 1)) && lastIndex > 0) {
            String prevToken = tokenList.get(--lastIndex);
            int iopt = path.lastIndexOf(prevToken, path.lastIndexOf(lastToken));
            String fullToken = path.substring(iopt);
            tokenList.remove(lastIndex);
            tokenList.set(lastIndex, fullToken);
        }
    }

    public static String[] splitPropertyPath(String path) {
        List split = (List)ObjectPathExpressionParser.parsePathExpression(null, path, SPLIT_PROPERTY_PATH_ENTRY);
        if (split == null || split.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        ObjectPropertyUtils.rejoinTrailingIndexReference(split, path);
        return split.toArray(new String[split.size()]);
    }

    public static String getPathTail(String path) {
        String[] propertyPaths = ObjectPropertyUtils.splitPropertyPath(path);
        return propertyPaths[propertyPaths.length - 1];
    }

    public static String removePathTail(String path) {
        Object[] propertyPaths = ObjectPropertyUtils.splitPropertyPath(path);
        return StringUtils.join((Object[])propertyPaths, (String)".", (int)0, (int)(propertyPaths.length - 1));
    }

    public static String getCanonicalPath(String path) {
        if (path == null || path.indexOf(91) == -1) {
            return path;
        }
        StringBuilder pathBuilder = new StringBuilder(path);
        int bracketCount = 0;
        int leftBracketPos = -1;
        for (int i = 0; i < pathBuilder.length(); ++i) {
            char c = pathBuilder.charAt(i);
            if (c == '[' && ++bracketCount == 1) {
                leftBracketPos = i;
            }
            if (c != ']') continue;
            if (--bracketCount < 0) {
                throw new IllegalArgumentException("Unmatched ']' at " + i + " " + String.valueOf(pathBuilder));
            }
            if (bracketCount != 0) continue;
            pathBuilder.delete(leftBracketPos, i + 1);
            i -= i + 1 - leftBracketPos;
            leftBracketPos = -1;
        }
        if (bracketCount > 0) {
            throw new IllegalArgumentException("Unmatched '[' at " + leftBracketPos + " " + String.valueOf(pathBuilder));
        }
        return pathBuilder.toString();
    }

    private ObjectPropertyUtils() {
    }

    private static Method getReadMethodByName(Class<?> beanClass, String propertyName) {
        try {
            return beanClass.getMethod("get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            Method readMethod = beanClass.getMethod("is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
            if (readMethod.getReturnType() == Boolean.class || readMethod.getReturnType() == Boolean.TYPE) {
                return readMethod;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static ObjectPropertyMetadata getMetadata(Class<?> beanClass) {
        ObjectPropertyMetadata metadata = METADATA_CACHE.get(beanClass);
        if (metadata == null) {
            metadata = new ObjectPropertyMetadata(beanClass);
            METADATA_CACHE.put(beanClass, metadata);
        }
        return metadata;
    }

    private static class ObjectPropertyMetadata {
        private final Map<String, PropertyDescriptor> propertyDescriptors;
        private final Map<String, Method> readMethods;
        private final Map<String, Method> writeMethods;
        private final Map<Class<?>, Set<String>> readablePropertyNamesByPropertyType = Collections.synchronizedMap(new WeakHashMap());
        private final Map<Class<?>, Set<String>> readablePropertyNamesByAnnotationType = Collections.synchronizedMap(new WeakHashMap());
        private final Map<Class<?>, Set<String>> readablePropertyNamesByCollectionType = Collections.synchronizedMap(new WeakHashMap());

        private Set<String> getReadablePropertyNamesByType(Class<?> propertyType) {
            Set<String> propertyNames = this.readablePropertyNamesByPropertyType.get(propertyType);
            if (propertyNames != null) {
                return propertyNames;
            }
            propertyNames = new LinkedHashSet<String>();
            for (Map.Entry<String, Method> readMethodEntry : this.readMethods.entrySet()) {
                Method readMethod = readMethodEntry.getValue();
                if (readMethod == null || !propertyType.isAssignableFrom(readMethod.getReturnType())) continue;
                propertyNames.add(readMethodEntry.getKey());
            }
            propertyNames = Collections.unmodifiableSet(propertyNames);
            this.readablePropertyNamesByPropertyType.put(propertyType, propertyNames);
            return propertyNames;
        }

        private Set<String> getReadablePropertyNamesByAnnotationType(Class<? extends Annotation> annotationType) {
            Set<String> propertyNames = this.readablePropertyNamesByAnnotationType.get(annotationType);
            if (propertyNames != null) {
                return propertyNames;
            }
            propertyNames = new LinkedHashSet<String>();
            for (Map.Entry<String, Method> readMethodEntry : this.readMethods.entrySet()) {
                Method readMethod = readMethodEntry.getValue();
                if (readMethod == null || !readMethod.isAnnotationPresent(annotationType)) continue;
                propertyNames.add(readMethodEntry.getKey());
            }
            propertyNames = Collections.unmodifiableSet(propertyNames);
            this.readablePropertyNamesByPropertyType.put(annotationType, propertyNames);
            return propertyNames;
        }

        private Set<String> getReadablePropertyNamesByCollectionType(Class<?> collectionType) {
            Set<String> propertyNames = this.readablePropertyNamesByCollectionType.get(collectionType);
            if (propertyNames != null) {
                return propertyNames;
            }
            propertyNames = new LinkedHashSet<String>();
            for (Map.Entry<String, Method> readMethodEntry : this.readMethods.entrySet()) {
                Type[] upperBounds;
                Method readMethod = readMethodEntry.getValue();
                if (readMethod == null) continue;
                Class<?> propertyClass = readMethod.getReturnType();
                if (propertyClass.isArray() && collectionType.isAssignableFrom(propertyClass.getComponentType())) {
                    propertyNames.add(readMethodEntry.getKey());
                    continue;
                }
                boolean isCollection = Collection.class.isAssignableFrom(propertyClass);
                boolean isMap = Map.class.isAssignableFrom(propertyClass);
                if (!isCollection && !isMap) continue;
                if (collectionType.equals(Object.class)) {
                    propertyNames.add(readMethodEntry.getKey());
                    continue;
                }
                Type propertyType = readMethodEntry.getValue().getGenericReturnType();
                if (!(propertyType instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)propertyType;
                Type valueType = parameterizedType.getActualTypeArguments()[isCollection ? 0 : 1];
                if (valueType instanceof WildcardType && (upperBounds = ((WildcardType)valueType).getUpperBounds()).length >= 1) {
                    valueType = upperBounds[0];
                }
                if (!(valueType instanceof Class) || !collectionType.isAssignableFrom((Class)valueType)) continue;
                propertyNames.add(readMethodEntry.getKey());
            }
            propertyNames = Collections.unmodifiableSet(propertyNames);
            this.readablePropertyNamesByCollectionType.put(collectionType, propertyNames);
            return propertyNames;
        }

        private Set<String> getWritablePropertyNames() {
            HashSet<String> writablePropertyNames = new HashSet<String>();
            for (Map.Entry<String, Method> writeMethodEntry : this.writeMethods.entrySet()) {
                writablePropertyNames.add(writeMethodEntry.getKey());
            }
            return writablePropertyNames;
        }

        private ObjectPropertyMetadata(Class<?> beanClass) {
            BeanInfo beanInfo;
            if (beanClass == null) {
                throw new RuntimeException("Class to retrieve property from was null");
            }
            try {
                beanInfo = Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException e) {
                LOG.warn("Bean Info not found for bean " + String.valueOf(beanClass), (Throwable)e);
                beanInfo = null;
            }
            LinkedHashMap<String, PropertyDescriptor> mutablePropertyDescriptorMap = new LinkedHashMap<String, PropertyDescriptor>();
            LinkedHashMap<String, Method> mutableReadMethodMap = new LinkedHashMap<String, Method>();
            LinkedHashMap<String, Method> mutableWriteMethodMap = new LinkedHashMap<String, Method>();
            if (beanInfo != null) {
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    String propertyName = propertyDescriptor.getName();
                    mutablePropertyDescriptorMap.put(propertyName, propertyDescriptor);
                    Method readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null) {
                        readMethod = ObjectPropertyUtils.getReadMethodByName(beanClass, propertyName);
                    }
                    if (readMethod != null && readMethod.isBridge()) {
                        readMethod = this.getCorrectedReadMethod(beanClass, readMethod);
                    }
                    mutableReadMethodMap.put(propertyName, readMethod);
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    assert (writeMethod == null || writeMethod.getParameterTypes().length == 1 && writeMethod.getParameterTypes()[0] != null) : writeMethod;
                    mutableWriteMethodMap.put(propertyName, writeMethod);
                }
            }
            this.propertyDescriptors = Collections.unmodifiableMap(mutablePropertyDescriptorMap);
            this.readMethods = Collections.unmodifiableMap(mutableReadMethodMap);
            this.writeMethods = Collections.unmodifiableMap(mutableWriteMethodMap);
        }

        private Method getCorrectedReadMethod(Class<?> beanClass, Method readMethod) {
            if (readMethod != null && !readMethod.getReturnType().isPrimitive() && this.isAbstractClassOrInterface(readMethod.getReturnType())) {
                Method implReadMethod = null;
                try {
                    implReadMethod = beanClass.getMethod(readMethod.getName(), readMethod.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (implReadMethod != null && this.isSubClass(implReadMethod.getReturnType(), readMethod.getReturnType())) {
                    return implReadMethod;
                }
            }
            return readMethod;
        }

        private boolean isAbstractClassOrInterface(Class<?> clazz) {
            return clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers());
        }

        private boolean isSubClass(Class<?> childClassCandidate, Class<?> parentClassCandidate) {
            return parentClassCandidate != childClassCandidate && parentClassCandidate.isAssignableFrom(childClassCandidate);
        }
    }

    private static class SplitPropertyPathEntry
    implements ObjectPathExpressionParser.PathEntry {
        private SplitPropertyPathEntry() {
        }

        @Override
        public List<String> parse(String parentPath, Object node, String next) {
            if (next == null) {
                return new ArrayList<String>();
            }
            List rv = (List)node;
            if (rv.isEmpty()) {
                rv.add(next);
                return rv;
            }
            ObjectPropertyUtils.rejoinTrailingIndexReference(rv, parentPath);
            rv.add(next);
            return rv;
        }
    }
}

