/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="suggest", parent="Uif-Suggest")
public class Suggest
extends WidgetBase {
    private static final long serialVersionUID = 7373706855319347225L;
    private AttributeQuery suggestQuery;
    private String valuePropertyName;
    private String labelPropertyName;
    private List<String> additionalPropertiesToReturn;
    private boolean returnFullQueryObject;
    private boolean retrieveAllSuggestions;
    private List<Object> suggestOptions;
    private String suggestOptionsJsString;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.suggestQuery != null) {
            ViewLifecycle.getExpressionEvaluator().evaluateExpressionsOnConfigurable(ViewLifecycle.getView(), this.suggestQuery, this.getContext());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (!this.isSuggestConfigured()) {
            this.setRender(false);
        }
        if (!this.isRender()) {
            return;
        }
        if (this.retrieveAllSuggestions) {
            if (this.suggestOptions == null || this.suggestOptions.isEmpty()) {
                if (this.suggestQuery.hasConfiguredMethod()) {
                    this.retrieveSuggestOptions(ViewLifecycle.getView());
                }
            } else {
                this.suggestOptionsJsString = ScriptUtils.translateValue(this.suggestOptions);
            }
        } else {
            InputField field = (InputField)parent;
            BindingInfo bindingInfo = field.getBindingInfo();
            this.suggestQuery.updateQueryFieldMapping(bindingInfo);
            if (this.suggestQuery != null) {
                this.suggestQuery.defaultQueryTarget(ViewLifecycle.getHelper());
            }
        }
    }

    public boolean isSuggestConfigured() {
        return StringUtils.isNotBlank((String)this.valuePropertyName) || this.suggestQuery.hasConfiguredMethod() || this.suggestOptions != null && !this.suggestOptions.isEmpty();
    }

    protected void retrieveSuggestOptions(View view) {
        block7: {
            String queryMethodToCall = this.suggestQuery.getQueryMethodToCall();
            MethodInvokerConfig queryMethodInvoker = this.suggestQuery.getQueryMethodInvokerConfig();
            if (queryMethodInvoker == null) {
                queryMethodInvoker = new MethodInvokerConfig();
            }
            if (StringUtils.isBlank((String)queryMethodInvoker.getTargetMethod())) {
                queryMethodInvoker.setTargetMethod(queryMethodToCall);
            }
            if (queryMethodInvoker.getTargetClass() == null && queryMethodInvoker.getTargetObject() == null) {
                queryMethodInvoker.setTargetObject(view.getViewHelperService());
            }
            try {
                queryMethodInvoker.prepare();
                Object methodResult = queryMethodInvoker.invoke();
                if (methodResult instanceof String) {
                    this.suggestOptionsJsString = (String)methodResult;
                    break block7;
                }
                if (methodResult instanceof List) {
                    this.suggestOptions = (List)methodResult;
                    this.suggestOptionsJsString = ScriptUtils.translateValue(this.suggestOptions);
                    break block7;
                }
                throw new RuntimeException("Suggest query method did not return List<String> for suggestions");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke query method: " + queryMethodInvoker.getTargetMethod(), e);
            }
        }
    }

    public SuggestPostData getPostData() {
        return new SuggestPostData(this);
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public AttributeQuery getSuggestQuery() {
        return this.suggestQuery;
    }

    public void setSuggestQuery(AttributeQuery suggestQuery) {
        this.suggestQuery = suggestQuery;
    }

    @BeanTagAttribute
    public String getValuePropertyName() {
        return this.valuePropertyName;
    }

    public void setValuePropertyName(String valuePropertyName) {
        this.valuePropertyName = valuePropertyName;
    }

    @BeanTagAttribute
    public String getLabelPropertyName() {
        return this.labelPropertyName;
    }

    public void setLabelPropertyName(String labelPropertyName) {
        this.labelPropertyName = labelPropertyName;
    }

    @BeanTagAttribute
    public List<String> getAdditionalPropertiesToReturn() {
        return this.additionalPropertiesToReturn;
    }

    public void setAdditionalPropertiesToReturn(List<String> additionalPropertiesToReturn) {
        this.additionalPropertiesToReturn = additionalPropertiesToReturn;
    }

    @BeanTagAttribute
    public boolean isReturnFullQueryObject() {
        return this.returnFullQueryObject;
    }

    public void setReturnFullQueryObject(boolean returnFullQueryObject) {
        this.returnFullQueryObject = returnFullQueryObject;
    }

    @BeanTagAttribute
    public boolean isRetrieveAllSuggestions() {
        return this.retrieveAllSuggestions;
    }

    public void setRetrieveAllSuggestions(boolean retrieveAllSuggestions) {
        this.retrieveAllSuggestions = retrieveAllSuggestions;
    }

    @BeanTagAttribute
    public List<Object> getSuggestOptions() {
        return this.suggestOptions;
    }

    public void setSuggestOptions(List<Object> suggestOptions) {
        this.suggestOptions = suggestOptions;
    }

    public String getSuggestOptionsJsString() {
        if (StringUtils.isNotBlank((String)this.suggestOptionsJsString)) {
            return this.suggestOptionsJsString;
        }
        return "null";
    }

    public void setSuggestOptionsJsString(String suggestOptionsJsString) {
        this.suggestOptionsJsString = suggestOptionsJsString;
    }

    public static class SuggestPostData
    implements Serializable {
        private static final long serialVersionUID = 997780560864981128L;
        private String id;
        private AttributeQuery suggestQuery;
        private String valuePropertyName;
        private String labelPropertyName;
        private List<String> additionalPropertiesToReturn;
        private boolean returnFullQueryObject;
        private boolean retrieveAllSuggestions;

        public SuggestPostData(Suggest suggest) {
            this.id = suggest.getId();
            this.suggestQuery = suggest.getSuggestQuery();
            this.valuePropertyName = suggest.getValuePropertyName();
            this.labelPropertyName = suggest.getLabelPropertyName();
            this.additionalPropertiesToReturn = suggest.getAdditionalPropertiesToReturn();
            this.returnFullQueryObject = suggest.isReturnFullQueryObject();
            this.retrieveAllSuggestions = suggest.isRetrieveAllSuggestions();
        }

        public String getId() {
            return this.id;
        }

        public AttributeQuery getSuggestQuery() {
            return this.suggestQuery;
        }

        public String getValuePropertyName() {
            return this.valuePropertyName;
        }

        public String getLabelPropertyName() {
            return this.labelPropertyName;
        }

        public List<String> getAdditionalPropertiesToReturn() {
            return this.additionalPropertiesToReturn;
        }

        public boolean isReturnFullQueryObject() {
            return this.returnFullQueryObject;
        }

        public boolean isRetrieveAllSuggestions() {
            return this.retrieveAllSuggestions;
        }
    }
}

