/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class UifRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private static final Logger LOG = LogManager.getLogger(UifRequestMappingHandlerMapping.class);
    private final Map<RequestMappingInfo, HandlerMethod> handlerMethods = new LinkedHashMap<RequestMappingInfo, HandlerMethod>();
    private final MultiValueMap<String, RequestMappingInfo> urlMap = new LinkedMultiValueMap();

    public Map<RequestMappingInfo, HandlerMethod> getHandlerMethods() {
        return Collections.unmodifiableMap(this.handlerMethods);
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        HandlerMethod newHandlerMethod = super.createHandlerMethod(handler, method);
        this.handlerMethods.put(mapping, newHandlerMethod);
        if (LOG.isInfoEnabled()) {
            LOG.info("Mapped \"" + String.valueOf(mapping) + "\" onto " + String.valueOf(newHandlerMethod));
        }
        if (!this.handlerMethods.containsKey(mapping)) {
            Set patterns = super.getMappingPathPatterns(mapping);
            for (String pattern : patterns) {
                if (super.getPathMatcher().isPattern(pattern)) continue;
                this.urlMap.add((Object)pattern, (Object)mapping);
            }
        }
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        ArrayList<Match> matches = new ArrayList<Match>();
        List directPathMatches = (List)this.urlMap.get((Object)lookupPath);
        if (directPathMatches != null) {
            this.addMatchingMappings(directPathMatches, matches, request);
        }
        if (matches.isEmpty()) {
            this.addMatchingMappings(this.handlerMethods.keySet(), matches, request);
        }
        if (!matches.isEmpty()) {
            Match secondBestMatch;
            MatchComparator comparator = new MatchComparator(super.getMappingComparator(request));
            Collections.sort(matches, comparator);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found " + matches.size() + " matching mapping(s) for [" + lookupPath + "] : " + String.valueOf(matches));
            }
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1 && comparator.compare(bestMatch, secondBestMatch = (Match)matches.get(1)) == 0) {
                Method m1 = bestMatch.handlerMethod.getMethod();
                Method m2 = secondBestMatch.handlerMethod.getMethod();
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + String.valueOf(request.getRequestURL()) + "': {" + String.valueOf(m1) + ", " + String.valueOf(m2) + "}");
            }
            this.handleMatch(bestMatch.mapping, lookupPath, request);
            return bestMatch.handlerMethod;
        }
        return this.handleNoMatch(this.handlerMethods.keySet(), lookupPath, request);
    }

    private void addMatchingMappings(Collection<RequestMappingInfo> mappings, List<Match> matches, HttpServletRequest request) {
        for (RequestMappingInfo mapping : mappings) {
            RequestMappingInfo match = this.getMatchingMapping(mapping, request);
            if (match == null) continue;
            matches.add(new Match(match, this.handlerMethods.get(mapping)));
        }
    }

    private static class MatchComparator
    implements Comparator<Match> {
        private final Comparator<RequestMappingInfo> comparator;

        public MatchComparator(Comparator<RequestMappingInfo> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    private static class Match {
        private final RequestMappingInfo mapping;
        private final HandlerMethod handlerMethod;

        private Match(RequestMappingInfo mapping, HandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }
}

