/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util.documentserializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityMetadata;

public class PropertySerializerTrieNode
implements PropertySerializabilityMetadata {
    private String pathString;
    private String propertyNameComponent;
    private PropertySerializabilityMetadata.PropertySerializability propertySerializability;
    private List<PropertySerializerTrieNode> childNodes;

    public PropertySerializerTrieNode(String pathString, String propertyNameComponent) {
        this.pathString = pathString;
        this.propertyNameComponent = propertyNameComponent;
        this.childNodes = null;
        this.propertySerializability = PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT;
    }

    public void addChildNode(PropertySerializerTrieNode child) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<PropertySerializerTrieNode>();
        }
        this.childNodes.add(child);
    }

    public String getPropertyNameComponent() {
        return this.propertyNameComponent;
    }

    public PropertySerializerTrieNode getChildNode(String propertyNameComponent) {
        if (this.childNodes == null) {
            return null;
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            PropertySerializerTrieNode childNode = this.childNodes.get(i);
            if (!childNode.getPropertyNameComponent().equals(propertyNameComponent)) continue;
            return childNode;
        }
        return null;
    }

    @Override
    public PropertySerializabilityMetadata getSerializableChildProperty(String propertyNameComponent) {
        return this.getChildNode(propertyNameComponent);
    }

    @Override
    public String getPathString() {
        return this.pathString;
    }

    @Override
    public PropertySerializabilityMetadata.PropertySerializability getPropertySerializability() {
        return this.propertySerializability;
    }

    public void setPropertySerializabilityToObjectAndAllPrimitives() {
        this.propertySerializability = PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT_AND_ALL_PRIMITIVES;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Path String: ").append(this.pathString).append(" Name component: ").append(this.propertyNameComponent);
        if (this.childNodes == null || this.childNodes.isEmpty()) {
            buf.append(" No child nodes.");
        } else {
            buf.append(" Child nodes: ");
            Iterator<PropertySerializerTrieNode> i = this.childNodes.iterator();
            while (i.hasNext()) {
                buf.append(i.next().getPropertyNameComponent());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        }
        return super.toString();
    }
}

