/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.model;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class RefreshStateModifyTask extends ViewLifecycleTaskBase<Component> {

    public RefreshStateModifyTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        LifecycleElementState phase = getElementState();
        if (!ViewLifecycle.isRefreshComponent(phase.getViewPhase(), phase.getViewPath())) {
            return;
        }

        Component component = (Component) getElementState().getElement();

        // force the component to render on a refresh
        component.setRender(true);

        // reset data if needed
        if (component.isResetDataOnRefresh()) {
            // TODO: this should handle groups as well, going through nested data fields
            if (component instanceof DataField) {
                // TODO: should check default value

                // clear value
                ObjectPropertyUtils.initializeProperty(ViewLifecycle.getModel(),
                        ((DataField) component).getBindingInfo().getBindingPath());
            }
        }
    }

}
