/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

/**
 * A complex attribute definition in the DataDictictionary. This can be be used to define
 * an attribute for a DataObjectEntry's attribute list which is represented by another
 * object entry definition. It will
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ComplexAttributeDefinition extends AttributeDefinitionBase {
    private static final long serialVersionUID = 3977923609388434447L;

    protected DataDictionaryEntry dataObjectEntry;

    /**
     * @return the dataObjectEntry
     */
    public DataDictionaryEntry getDataObjectEntry() {
        return this.dataObjectEntry;
    }

    /**
     * @param dataObjectEntry the dataObjectEntry to set
     */
    public void setDataObjectEntry(DataDictionaryEntry dataObjectEntry) {
        this.dataObjectEntry = dataObjectEntry;
    }

    @Override
    public void completeValidation(Class<?> rootObjectClass, Class<?> otherObjectClass, ValidationTrace tracer) {
        tracer.addBean(this.getClass().getSimpleName(), "id: " + getId());
        if (getDataObjectEntry() == null) {
            String currentValues[] = {"id = " + getId(), "class = " + rootObjectClass.getName()};
            tracer.createError("ComplexAttributeDefinition missing dataObjectClass", currentValues);
        }
    }
}
