/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.document.Document;

import java.util.ArrayList;
import java.util.List;

/**
 * This class represents the save event that is part of an eDoc in Kuali. This could be triggered when a user presses the save
 * button for a given document or it could happen when another piece of code calls the save method in the document service. This
 * event does not trigger sub-events for validation.
 *
 *
 */
public class SaveOnlyDocumentEvent extends SaveDocumentEvent {
    /**
     * Constructs a SaveOnlyDocumentEvent with the specified errorPathPrefix and document
     *
     * @param document
     * @param errorPathPrefix
     */
    public SaveOnlyDocumentEvent(String errorPathPrefix, Document document) {
        this("creating save event using no generated events for document " + getDocumentId(document), errorPathPrefix, document);
    }

    /**
     * Constructs a SaveDocumentEvent with the given document
     *
     * @param document
     */
    public SaveOnlyDocumentEvent(Document document) {
        this("", document);
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.DocumentEventBase#DocumentEventBase(java.lang.String, java.lang.String, org.kuali.rice.krad.document.Document)
     */
    public SaveOnlyDocumentEvent(String description, String errorPathPrefix, Document document) {
	super(description, errorPathPrefix, document);
    }

    /**
     * This overridden method returns an empty list always
     *
     * @see org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent#generateEvents()
     */
    @Override
    public List<RuleEvent> generateEvents() {
	return new ArrayList<RuleEvent>();
    }


}
