/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a group of HTML checkbox controls. Provides preset options for the
 * user to choose by a series of checkbox controls. Only or more options can be
 * select.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "verticalCheckboxesControl", parent = "Uif-VerticalCheckboxesControl"),
        @BeanTag(name = "horizontalCheckboxesControl", parent = "Uif-HorizontalCheckboxesControl")})
public class CheckboxGroupControl extends MultiValueControlBase {
    private static final long serialVersionUID = 8800478332086081970L;

    private String delimiter;

    private List<String> fieldsetClasses;

    public CheckboxGroupControl() {
        super();

        fieldsetClasses = new ArrayList<String>();
    }

    /**
     * Delimiter string to be rendered between the checkbox group options
     *
     * <p>
     * defaults to none.
     * </p>
     *
     * @return delimiter string
     */
    @BeanTagAttribute
    public String getDelimiter() {
        return this.delimiter;
    }

    /**
     * Setter for the string delimiter for each checkbox option
     *
     * @param delimiter
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * Get fieldsetClasses which are the classes that will be applied to this component's fieldset when generated
     *
     * @return fieldset css classes
     */
    @BeanTagAttribute
    public List<String> getFieldsetClasses() {
        return fieldsetClasses;
    }

    /**
     * Set fieldsetClasses - css classes for the element
     *
     * @param fieldsetClasses fieldset css classes list
     */
    public void setFieldsetClasses(List<String> fieldsetClasses) {
        this.fieldsetClasses = fieldsetClasses;
    }

    /**
     * Builds the HTML class attribute string by combining the fieldsetClasses list
     * with a space delimiter
     *
     * @return class attribute string
     */
    public String getFieldsetClassesAsString() {
        if (fieldsetClasses != null) {
            return StringUtils.join(fieldsetClasses, " ");
        }

        return "";
    }
}
