/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

/**
 * Class used to format
 * <code>org.kuali.rice.core.api.util.type.KualiInteger</code> in the local currency
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UifKualiIntegerCurrencyEditor extends UifCurrencyEditor {

    /**
     * This overridden method converts the display string to a
     * <code>org.kuali.rice.core.api.util.type.KualiInteger</code> object using
     * local currency format.
     *
     * @see UifCurrencyEditor#setAsText(java.lang.String)
     */
    @Override
    public void setAsText(String text) {
        KualiDecimal value = (KualiDecimal) (super.convertToObject(text));
        this.setValue(new KualiInteger(value.longValue()));
    }

}
