/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.inquiry;

import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.service.ControllerService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Controller service that extends {@link org.kuali.rice.krad.web.service.ControllerService} and adds
 * methods specific to inquiry views.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface InquiryControllerService extends ControllerService {

    /**
     * When the data object is a {@link org.kuali.rice.krad.bo.PersistableAttachment} or
     * {@link org.kuali.rice.krad.bo.PersistableAttachmentList}, streams the selected attachment back to the
     * response.
     *
     * @param form form instance containing the inquiry data
     * @param response Http response for returning the attachment contents
     */
    void downloadDataObjectAttachment(InquiryForm form, HttpServletResponse response);

    /**
     * When the data object is a custom object, streams the requested attachment back to the
     * response.
     *
     * @param form form instance containing the inquiry data
     * @param request Http request for sending the fileName, contentType, and fileContentDataObjField
     * @param response Http response for returning the attachment contents
     */
    void downloadCustomDataObjectAttachment(InquiryForm form, HttpServletRequest request,
            HttpServletResponse response) throws Exception;

    /**
     * Invoked to download an attachment that has been uploaded for a note.
     *
     * @param form form instance containing the note (and attachment) instance
     * @param response http servlet response instance for sending back the attachment contents
     * @return ModelAndView instance for rendering the document view, or null if the response has been
     * finished
     */
    void downloadBONote(InquiryForm form, HttpServletResponse response);
}
