/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that provides handling for query methods suggest as performing a lookup, field suggest,
 * and field query.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface QueryControllerService {

    /**
     * Handles the perform lookup action by building up a URL to the lookup view and configuring
     * a redirect.
     *
     * @param form form instance containing the model data
     * @return ModelAndView configured for redirecting to the lookup view
     */
    ModelAndView performLookup(UifFormBase form);

    /**
     * Invoked to provides options (execute a query) for a field that contains a suggest widget.
     *
     * @param form form instance containing the model data
     * @return AttributeQueryResult containing the results of the suggest query
     */
    AttributeQueryResult performFieldSuggest(UifFormBase form);

    /**
     * Invoked to execute the attribute query associated with a field given the query parameters
     * found in the request
     *
     * @param form form instance containing the model data
     * @return AttributeQueryResult containing the results of the field query
     */
    AttributeQueryResult performFieldQuery(UifFormBase form);
}
