/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.exporter;

import java.util.Collections;
import java.util.Map;

/*
 * An ExportMap represents an entry or definition from the dataDictionary as a Map of the contents of that entry or definintion, and
 * the key by which that entry or definition will be stored in the parent Map.
 * 
 * 
 */
@Deprecated
public class ExportMap {
    private final String exportKey;
    private final StringMap exportData;

    public ExportMap(String exportKey) {
        this.exportKey = exportKey;
        this.exportData = new StringMap();
    }

    /**
     * @return exportKey associated with this instance
     */
    public String getExportKey() {
        return this.exportKey;
    }

    /**
     * @return unmodifiable copy of the exportData associated with this Map
     */
    public Map<String, Object> getExportData() {
        return Collections.unmodifiableMap(this.exportData);
    }

    /**
     * Adds the ExportMap's exportKey and exportData as a key,value pair to this Map
     */
    public void set(ExportMap map) {
        if (map == null) {
            throw new IllegalArgumentException("invalid (null) map");
        }

        exportData.set(map.getExportKey(), map.getExportData());
    }

    /**
     * If the given map is not null, adds the ExportMap's exportKey and exportData as a key,value pair to this Map.
     */
    public void setOptional(ExportMap map) {
        if (map != null) {
            set(map);
        }
    }

    /**
     * Adds the given key,value pair to this Map
     *
     * @param key
     * @param value
     */
    public void set(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("invalid (null) key");
        }
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) value - key=" + key);
        }

        exportData.set(key, value);
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return this.exportKey + "(" + this.exportData.size() + " children)";
    }
}
