/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.resolver;

import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.SimpleConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleConstraintResolver<T extends Constrainable> implements ConstraintResolver<T> {

    /**
     * Return SimpleConstraint if SimpleConstrainable, otherwise return an empty list.
     *
     * @param definition Definition to extract a SimpleConstraint from
     * @param <C> SimpleConstraint
     * @return SimpleConstraint if SimpleConstrainable, otherwise return an empty list.
     */
    @Override
    public <C extends Constraint> List<C> resolve(T definition) {
        if (definition instanceof SimpleConstrainable) {
            C simpleConstraint = (C) (((SimpleConstrainable) definition).getSimpleConstraint());
            return Collections.singletonList(simpleConstraint);
        } else {
            return new ArrayList<C>();
        }
    }
}
