/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.view;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.web.form.UifFormBase;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Implementation of {@link ViewPresentationController} that implements no logic by default
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "viewPresentationController")
public class ViewPresentationControllerBase implements ViewPresentationController, Serializable {
    private static final long serialVersionUID = -3199587372204398503L;

    private RequestAuthorizationCache requestAuthorizationCache;

    /**
     * @see ViewPresentationController#getActionFlags(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.web.form.UifFormBase)
     */
    @Override
    public Set<String> getActionFlags(View view, UifFormBase model) {
        return new HashSet<String>();
    }

    /**
     * @see ViewPresentationController#getEditModes(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.web.form.UifFormBase)
     */
    @Override
    public Set<String> getEditModes(View view, UifFormBase model) {
        return new HashSet<String>();
    }

    /**
     * @see ViewPresentationController#canEditView(org.kuali.rice.krad.uif.view.View, org.kuali.rice.krad.uif.view.ViewModel)
     */
    @Override
    public boolean canEditView(View view, ViewModel model) {
        return true;
    }

    /**
     * @see ViewPresentationController#canEditField(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.field.Field, java.lang.String)
     */
    @Override
    public boolean canEditField(View view, ViewModel model, Field field, String propertyName) {
        return true;
    }

    /**
     * @see ViewPresentationController#canViewField(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.field.Field, java.lang.String)
     */
    @Override
    public boolean canViewField(View view, ViewModel model, Field field, String propertyName) {
        return true;
    }

    /**
     * @see ViewPresentationController#fieldIsRequired(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.field.Field, java.lang.String)
     */
    @Override
    public boolean fieldIsRequired(View view, ViewModel model, Field field, String propertyName) {
        return false;
    }

    /**
     * @see ViewPresentationController#canEditGroup(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.Group, java.lang.String)
     */
    @Override
    public boolean canEditGroup(View view, ViewModel model, Group group, String groupId) {
        return true;
    }

    /**
     * @see ViewPresentationController#canViewGroup(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.Group, java.lang.String)
     */
    @Override
    public boolean canViewGroup(View view, ViewModel model, Group group, String groupId) {
        return true;
    }

    /**
     * @see ViewPresentationController#canEditWidget(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.widget.Widget, java.lang.String)
     */
    @Override
    public boolean canEditWidget(View view, ViewModel model, Widget widget, String widgetId) {
        return true;
    }

    /**
     * @see ViewPresentationController#canViewWidget(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.widget.Widget, java.lang.String)
     */
    @Override
    public boolean canViewWidget(View view, ViewModel model, Widget widget, String widgetId) {
        return true;
    }

    /**
     * @see ViewPresentationController#canPerformAction(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.element.Action, java.lang.String,
     * java.lang.String)
     */
    @Override
    public boolean canPerformAction(View view, ViewModel model, Action action, String actionEvent,
                                    String actionId) {
        return true;
    }

    /**
     * @see ViewPresentationController#canEditLine(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.CollectionGroup,
     * java.lang.String, java.lang.Object)
     */
    @Override
    public boolean canEditLine(View view, ViewModel model, CollectionGroup collectionGroup,
                               String collectionPropertyName, Object line) {
        return true;
    }

    /**
     * @see ViewPresentationController#canViewLine(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.CollectionGroup,
     * java.lang.String, java.lang.Object)
     */
    @Override
    public boolean canViewLine(View view, ViewModel model, CollectionGroup collectionGroup,
                               String collectionPropertyName, Object line) {
        return true;
    }

    /**
     * @see ViewPresentationController#canEditLineField(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.CollectionGroup,
     * java.lang.String, java.lang.Object, org.kuali.rice.krad.uif.field.Field, java.lang.String)
     */
    @Override
    public boolean canEditLineField(View view, ViewModel model, CollectionGroup collectionGroup,
                                    String collectionPropertyName, Object line, Field field, String propertyName) {
        return true;
    }

    /**
     * @see ViewPresentationController#canViewLineField(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.CollectionGroup,
     * java.lang.String, java.lang.Object, org.kuali.rice.krad.uif.field.Field, java.lang.String)
     */
    @Override
    public boolean canViewLineField(View view, ViewModel model, CollectionGroup collectionGroup,
                                    String collectionPropertyName, Object line, Field field, String propertyName) {
        return true;
    }

    /**
     * @see ViewPresentationController#canPerformLineAction(org.kuali.rice.krad.uif.view.View,
     * org.kuali.rice.krad.uif.view.ViewModel, org.kuali.rice.krad.uif.container.CollectionGroup,
     * java.lang.String, java.lang.Object, org.kuali.rice.krad.uif.element.Action, java.lang.String,
     * java.lang.String)
     */
    @Override
    public boolean canPerformLineAction(View view, ViewModel model, CollectionGroup collectionGroup,
                                        String collectionPropertyName, Object line, Action action, String actionEvent, String actionId) {
        return true;
    }

    protected RequestAuthorizationCache getRequestAuthorizationCache() {
        return requestAuthorizationCache;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setRequestAuthorizationCache(RequestAuthorizationCache requestAuthorizationCache) {
        this.requestAuthorizationCache = requestAuthorizationCache;
    }

}
