/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ObjectPathExpressionParser;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.KRADUtils;

public class ObjectPropertyReference {
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final byte DEFAULT_BYTE = 0;
    private static final short DEFAULT_SHORT = 0;
    private static final int DEFAULT_INT = 0;
    private static final long DEFAULT_LONG = 0L;
    private static final float DEFAULT_FLOAT = 0.0f;
    private static final double DEFAULT_DOUBLE = 0.0;
    private static final char DEFAULT_CHAR = '\u0000';
    private static final Logger LOG = LogManager.getLogger(ObjectPropertyReference.class);
    private static final ThreadLocal<ObjectPropertyReference> TL_BUILDER_REF = new ThreadLocal();
    private static final ThreadLocal<Boolean> TL_WARN = new ThreadLocal();
    private static final ReferencePathEntry LOOKUP_REF_PATH_ENTRY = new ReferencePathEntry(false);
    private static final ReferencePathEntry MUTATE_REF_PATH_ENTRY = new ReferencePathEntry(true);
    private Object rootBean;
    private Object bean;
    private Class<?> beanClass;
    private Type beanType;
    private String name;
    private String parentPath;
    private String rootPath;

    private static Object initialize(Object propertyValue, Class<?> propertyType) {
        Cloneable returnValue = propertyValue;
        if (propertyValue == null) {
            if (List.class.equals(propertyType)) {
                returnValue = new LinkedList();
            } else if (Map.class.equals(propertyType)) {
                returnValue = new HashMap();
            } else if (!String.class.equals(propertyType)) {
                try {
                    returnValue = propertyType.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Failed to create new object for setting property value", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to create new object for setting property value", e);
                }
            }
        }
        return returnValue;
    }

    private static Object getArray(Object array, String name) {
        int i;
        if (array == null) {
            return null;
        }
        for (i = 0; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return null;
        }
        i = Integer.parseInt(name);
        if (i >= Array.getLength(array)) {
            return null;
        }
        return Array.get(array, i);
    }

    private static void setArray(Object array, String name, Object value) {
        Array.set(array, Integer.parseInt(name), value);
    }

    private static Object getList(List<?> list, String name) {
        int i;
        int length = list == null ? 0 : list.size();
        for (i = 0; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return null;
        }
        i = Integer.parseInt(name);
        if (i >= length) {
            return null;
        }
        return list.get(i);
    }

    private static void setList(List<?> list, String name, Object value) {
        int i = Integer.parseInt(name);
        while (i >= list.size()) {
            list.add(null);
        }
        list.set(i, value);
    }

    private static Object getMap(Map<?, ?> map, String name) {
        if (map != null && map.containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public static boolean isWarning() {
        return Boolean.TRUE.equals(TL_WARN.get());
    }

    public static void setWarning(boolean warning) {
        if (warning) {
            TL_WARN.set(true);
        } else {
            TL_WARN.remove();
        }
    }

    public static ObjectPropertyReference resolvePath(Object bean, Class<?> beanClass, String propertyPath, boolean grow) {
        if (ObjectPathExpressionParser.isPath(propertyPath)) {
            ObjectPropertyReference reference = new ObjectPropertyReference();
            reference.beanClass = beanClass;
            reference.rootPath = propertyPath;
            if (bean instanceof Copyable) {
                reference.rootBean = reference.bean = CopyUtils.unwrap((Copyable)bean);
                if (!beanClass.isInstance(reference.bean)) {
                    reference.beanClass = reference.bean.getClass();
                }
            } else {
                reference.bean = bean;
                reference.rootBean = bean;
            }
            ObjectPropertyReference resolved = (ObjectPropertyReference)ObjectPathExpressionParser.parsePathExpression(reference, propertyPath, grow ? MUTATE_REF_PATH_ENTRY : LOOKUP_REF_PATH_ENTRY);
            reference.bean = resolved.bean;
            reference.beanClass = resolved.beanClass;
            reference.beanType = resolved.beanType;
            reference.name = resolved.name;
            return reference;
        }
        return ObjectPropertyReference.resolveProperty(bean, beanClass, propertyPath);
    }

    public static ObjectPropertyReference resolveProperty(Object bean, Class<?> beanClass, String propertyPath) {
        ObjectPropertyReference reference = TL_BUILDER_REF.get();
        if (reference == null) {
            reference = new ObjectPropertyReference();
            TL_BUILDER_REF.set(reference);
        }
        reference.beanClass = beanClass;
        if (bean instanceof Copyable) {
            reference.bean = CopyUtils.unwrap((Copyable)bean);
            if (!beanClass.isInstance(reference.bean) && reference.bean != null) {
                reference.beanClass = reference.bean.getClass();
            }
        } else {
            reference.bean = bean;
        }
        reference.rootBean = reference.bean;
        reference.rootPath = propertyPath;
        reference.beanType = reference.beanClass;
        reference.name = propertyPath;
        return reference;
    }

    private ObjectPropertyReference() {
    }

    private Object convertStringToPropertyType(String propertyValue) {
        Class<?> propertyType = this.getPropertyType();
        if (List.class.equals(propertyType)) {
            return KRADUtils.convertStringParameterToList(propertyValue);
        }
        if (Map.class.equals(propertyType)) {
            return KRADUtils.convertStringParameterToMap(propertyValue);
        }
        PropertyEditor editor = ObjectPropertyUtils.getPropertyEditor(this.rootBean, this.rootPath);
        if (editor == null) {
            throw new IllegalArgumentException("No property editor available for converting '" + propertyValue + "' to " + String.valueOf(propertyType));
        }
        editor.setAsText(propertyValue);
        return editor.getValue();
    }

    private Object convertPropertyValueToString(Object propertyValue) {
        if (propertyValue instanceof List) {
            StringBuilder listStringBuilder = new StringBuilder();
            for (Object item : (List)propertyValue) {
                if (listStringBuilder.length() > 0) {
                    listStringBuilder.append(',');
                }
                listStringBuilder.append((String)item);
            }
            return listStringBuilder.toString();
        }
        if (propertyValue instanceof Map) {
            Map mapPropertyValue = (Map)propertyValue;
            return KRADUtils.buildMapParameterString(mapPropertyValue);
        }
        PropertyEditor editor = ObjectPropertyUtils.getPropertyEditor(ObjectPropertyUtils.getPrimitiveType(propertyValue.getClass()));
        if (editor == null) {
            throw new IllegalArgumentException("No property editor available for converting '" + String.valueOf(propertyValue) + "' from " + String.valueOf(propertyValue.getClass()));
        }
        editor.setValue(propertyValue);
        return editor.getAsText();
    }

    private Object convertToPropertyType(Object propertyValue) {
        Class<?> propertyType = this.getPropertyType();
        if (propertyValue == null) {
            return this.primitiveDefault(propertyType);
        }
        if (propertyType.isInstance(propertyValue)) {
            return propertyValue;
        }
        if (propertyValue instanceof String) {
            return this.convertStringToPropertyType((String)propertyValue);
        }
        if (propertyType.equals(String.class)) {
            return this.convertPropertyValueToString(propertyValue);
        }
        return propertyValue;
    }

    private Object primitiveDefault(Class<?> object) {
        if (!object.isPrimitive()) {
            return null;
        }
        if (object.equals(Boolean.TYPE)) {
            return false;
        }
        if (object.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (object.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (object.equals(Short.TYPE)) {
            return (short)0;
        }
        if (object.equals(Integer.TYPE)) {
            return 0;
        }
        if (object.equals(Long.TYPE)) {
            return 0L;
        }
        if (object.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (object.equals(Double.TYPE)) {
            return 0.0;
        }
        return null;
    }

    public Object getBean() {
        return this.bean;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Class<?> getImplClass() {
        assert (this.bean == null || this.beanClass.isInstance(this.bean)) : String.valueOf(this.bean) + " is not a " + String.valueOf(this.beanClass);
        return this.bean == null ? this.beanClass : this.bean.getClass();
    }

    public String getName() {
        return this.name;
    }

    private boolean isListOrArrayAndCanReadOrWrite() {
        Class<?> implClass = this.getImplClass();
        if (!implClass.isArray() && !List.class.isAssignableFrom(implClass)) {
            return false;
        }
        if (this.name.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.name.length(); ++i) {
            if (Character.isDigit(this.name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Boolean canReadOrWriteSimple() {
        if (this.name == null) {
            return true;
        }
        Class<?> implClass = this.getImplClass();
        if (implClass == null) {
            return false;
        }
        if (this.isListOrArrayAndCanReadOrWrite()) {
            return true;
        }
        if (Map.class.isAssignableFrom(implClass)) {
            return true;
        }
        return null;
    }

    public boolean canRead() {
        Boolean simple = this.canReadOrWriteSimple();
        if (simple != null) {
            return simple;
        }
        return ObjectPropertyUtils.getReadMethod(this.getImplClass(), this.name) != null;
    }

    public boolean canWrite() {
        Boolean simple = this.canReadOrWriteSimple();
        if (simple != null) {
            return simple;
        }
        return ObjectPropertyUtils.getWriteMethod(this.getImplClass(), this.name) != null;
    }

    public Object getFromReadMethod() {
        Class<?> implClass = this.getImplClass();
        Method readMethod = ObjectPropertyUtils.getReadMethod(implClass, this.name);
        if (readMethod == null) {
            if (ObjectPropertyReference.isWarning()) {
                IllegalArgumentException missingPropertyException = new IllegalArgumentException("No property name '" + this.name + "' is readable on " + (String)(implClass == this.beanClass ? implClass.toString() : "impl " + String.valueOf(implClass) + ", bean " + String.valueOf(this.beanClass)));
                LOG.warn((Object)missingPropertyException);
            }
            return null;
        }
        try {
            return readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Illegal access invoking property read method " + String.valueOf(readMethod), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                LOG.debug(e.getMessage(), (Throwable)e);
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                LOG.debug(e.getMessage(), (Throwable)e);
                throw (Error)cause;
            }
            throw new IllegalStateException("Unexpected invocation target exception invoking property read method " + String.valueOf(readMethod), e);
        }
    }

    public Object get() {
        if (this.name == null) {
            return this.bean;
        }
        Class<?> implClass = this.getImplClass();
        if (implClass == null || this.bean == null) {
            return null;
        }
        if (implClass.isArray()) {
            return ObjectPropertyReference.getArray(this.bean, this.name);
        }
        if (List.class.isAssignableFrom(implClass)) {
            return ObjectPropertyReference.getList((List)this.bean, this.name);
        }
        if (Map.class.isAssignableFrom(implClass)) {
            return ObjectPropertyReference.getMap((Map)this.bean, this.name);
        }
        return this.getFromReadMethod();
    }

    private Class<?> getCollectionPropertyType() {
        ParameterizedType parameterizedType;
        Type valueType;
        Object refBean;
        Class<?> implClass = this.getImplClass();
        boolean isMap = Map.class.isAssignableFrom(implClass);
        boolean isList = List.class.isAssignableFrom(implClass);
        if (isMap) {
            refBean = ObjectPropertyReference.getMap((Map)this.bean, this.name);
        } else if (isList) {
            refBean = ObjectPropertyReference.getList((List)this.bean, this.name);
        } else {
            return null;
        }
        if (refBean != null) {
            return refBean.getClass();
        }
        if (this.beanType instanceof ParameterizedType && (valueType = (parameterizedType = (ParameterizedType)this.beanType).getActualTypeArguments()[isList ? 0 : 1]) instanceof Class) {
            return (Class)valueType;
        }
        return Object.class;
    }

    private Class<?> getPropertyTypeFromReadOrWriteMethod() {
        Method writeMethod;
        Class<?> implClass = this.getImplClass();
        Method readMethod = ObjectPropertyUtils.getReadMethod(implClass, this.name);
        if (readMethod == null) {
            Method writeMethod2 = ObjectPropertyUtils.getWriteMethod(implClass, this.name);
            assert (writeMethod2 == null || writeMethod2.getParameterTypes().length == 1) : "Invalid write method " + String.valueOf(writeMethod2);
            if (writeMethod2 == null && ObjectPropertyReference.isWarning()) {
                IllegalArgumentException missingPropertyException = new IllegalArgumentException("No property name '" + this.name + "' is readable or writable on " + (String)(implClass == this.beanClass ? implClass.toString() : "impl " + String.valueOf(implClass) + ", bean " + String.valueOf(this.beanClass)));
                LOG.warn((Object)missingPropertyException);
            }
            return writeMethod2 == null ? null : writeMethod2.getParameterTypes()[0];
        }
        Class<?> returnType = readMethod.getReturnType();
        assert ((writeMethod = ObjectPropertyUtils.getWriteMethod(implClass, this.name)) == null || writeMethod.getParameterTypes()[0].isAssignableFrom(returnType)) : "Property types don't match " + String.valueOf(readMethod) + " " + String.valueOf(writeMethod);
        return returnType;
    }

    public Class<?> getPropertyType() {
        Class<?> implClass = this.getImplClass();
        if (implClass == null) {
            return null;
        }
        if (this.name == null) {
            return this.getImplClass();
        }
        Class<?> propertyType = this.getCollectionPropertyType();
        if (propertyType != null) {
            return propertyType;
        }
        return this.getPropertyTypeFromReadOrWriteMethod();
    }

    private void setUsingWriteMethod(Object propertyValue) {
        Class<?> implClass = this.getImplClass();
        Method writeMethod = ObjectPropertyUtils.getWriteMethod(implClass, this.name);
        if (writeMethod == null) {
            throw new IllegalArgumentException("No property name '" + this.name + "' is writable on " + (String)(implClass == this.beanClass ? implClass.toString() : "impl " + String.valueOf(implClass) + ", bean " + String.valueOf(this.beanClass)));
        }
        try {
            writeMethod.invoke(this.bean, propertyValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Illegal access invoking property write method " + String.valueOf(writeMethod), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                LOG.debug(e.getMessage(), (Throwable)e);
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                LOG.debug(e.getMessage(), (Throwable)e);
                throw (Error)cause;
            }
            throw new IllegalStateException("Unexpected invocation target exception invoking property write method " + String.valueOf(writeMethod), e);
        }
    }

    public void set(Object propertyValue) {
        if (this.name == null) {
            throw new IllegalArgumentException("Cannot modify a self-reference");
        }
        if (this.bean == null) {
            throw new IllegalArgumentException("Reference is null");
        }
        propertyValue = this.convertToPropertyType(propertyValue);
        Class<?> implClass = this.getImplClass();
        if (implClass == null) {
            throw new IllegalArgumentException("No property name '" + this.name + "' is writable on " + String.valueOf(this.beanClass));
        }
        if (implClass.isArray()) {
            ObjectPropertyReference.setArray(this.bean, this.name, propertyValue);
        } else if (List.class.isAssignableFrom(implClass)) {
            ObjectPropertyReference.setList((List)this.bean, this.name, propertyValue);
        } else if (Map.class.isAssignableFrom(implClass)) {
            Map uncheckedMap = (Map)this.bean;
            uncheckedMap.put(this.name, propertyValue);
        } else {
            this.setUsingWriteMethod(propertyValue);
        }
    }

    private static final class ReferencePathEntry
    implements ObjectPathExpressionParser.PathEntry {
        private final boolean grow;

        private ReferencePathEntry(boolean grow) {
            this.grow = grow;
        }

        @Override
        public Object parse(String parentPath, Object node, String next) {
            Object newBean;
            Method readMethod;
            ObjectPropertyReference current = (ObjectPropertyReference)node;
            if (next == null) {
                ObjectPropertyReference resolved = new ObjectPropertyReference();
                resolved.rootBean = current.bean;
                resolved.rootPath = current.rootPath;
                resolved.bean = current.bean;
                resolved.beanClass = current.beanClass;
                resolved.beanType = current.beanType;
                resolved.name = null;
                resolved.parentPath = null;
                return resolved;
            }
            Class<?> beanClass = current.getPropertyType();
            Object bean = current.get();
            if (bean instanceof Copyable && !beanClass.isInstance(bean = CopyUtils.unwrap((Copyable)bean))) {
                beanClass = bean.getClass();
            }
            Type beanType = (readMethod = ObjectPropertyUtils.getReadMethod(current.getImplClass(), current.name)) == null ? beanClass : readMethod.getGenericReturnType();
            if (this.grow && (newBean = ObjectPropertyReference.initialize(bean, beanClass)) != bean) {
                Object verify;
                current.set(newBean);
                assert ((verify = current.get()) == newBean) : String.valueOf(verify) + " != " + String.valueOf(newBean);
                bean = newBean;
            }
            current.bean = bean;
            current.beanClass = beanClass;
            current.beanType = beanType;
            current.name = next;
            current.parentPath = parentPath;
            return current;
        }
    }
}

