/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.mask;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * The maskLiteral element is used to completely hide the field value for
 * unauthorized users. The specified literal will be shown instead of the field
 * value.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "maskFormatterLiteral")
public class MaskFormatterLiteral implements MaskFormatter {
    private static final long serialVersionUID = 3368293409242411693L;

    protected String literal = "********";

    @Override
    public String maskValue(Object value) {
        return literal;
    }

    /**
     * Gets the literalString attribute.
     *
     * @return Returns the literal String.
     */
    @BeanTagAttribute(name = "literal")
    public String getLiteral() {
        return literal;
    }

    /**
     * Specify the string that will be shown instead of the actual value when masked.
     */
    public void setLiteral(String literal) {
        this.literal = literal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MaskFormatterLiteral [");
        if (literal != null) {
            builder.append("literal=").append(literal);
        }
        builder.append("]");
        return builder.toString();
    }

}
