/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

/**
 * General component that allows custom HTML to be inserted into the view.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "content", parent = "Uif-Content")})
public class Content extends ContentElementBase {
    private static final long serialVersionUID = 1992141937575230344L;

    private String markup;

    public Content() {
        super();

        setSelfRendered(true);
    }

    /**
     * HTML content that should be rendered in the components position.
     *
     * <p>Note this is not exported as bean tag attribute. Special handling allows the content to be
     * embedded within the content tag without specifying the markup property.</p>
     *
     * @return String html markup
     */
    public String getMarkup() {
        return markup;
    }

    /**
     * @see Content#getMarkup()
     */
    public void setMarkup(String markup) {
        this.markup = markup;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getRenderedHtmlOutput() {
        return getMarkup();
    }

}

