/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="label", parent="Uif-Label")
public class Label
extends ContentElementBase {
    private static final long serialVersionUID = -6491546893195180114L;
    private String labelText;
    private String labelForComponentId;
    private boolean renderColon = true;
    private String requiredIndicator;
    private boolean renderRequiredIndicator;
    private Message richLabelMessage;
    private List<Component> inlineComponents;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.richLabelMessage == null && this.labelText != null && this.labelText.contains("[") && this.labelText.contains("]")) {
            Message message = ComponentFactory.getMessage();
            message.setMessageText(this.labelText);
            message.setInlineComponents(this.inlineComponents);
            message.setRenderWrapperTag(false);
            this.setRichLabelMessage(message);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isBlank((String)this.getLabelText())) {
            this.setRender(false);
        }
        String defaultRequiredIndicator = (String)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-RequiredIndicator");
        if (this.requiredIndicator != null && !this.requiredIndicator.equals(defaultRequiredIndicator)) {
            this.addDataAttribute("req_indicator", this.requiredIndicator);
        } else if (this.requiredIndicator == null) {
            this.requiredIndicator = defaultRequiredIndicator;
        }
        if (this.getRequired() != null && this.getRequired().booleanValue()) {
            this.setRenderRequiredIndicator(true);
        }
        if (this.isHidden()) {
            this.addStyleClass("sr-only");
        }
    }

    @BeanTagAttribute
    public String getLabelForComponentId() {
        return this.labelForComponentId;
    }

    public void setLabelForComponentId(String labelForComponentId) {
        this.labelForComponentId = labelForComponentId;
    }

    @BeanTagAttribute
    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    @BeanTagAttribute
    public boolean isRenderColon() {
        return this.renderColon;
    }

    public void setRenderColon(boolean renderColon) {
        this.renderColon = renderColon;
    }

    public boolean isRenderRequiredIndicator() {
        return this.renderRequiredIndicator;
    }

    public void setRenderRequiredIndicator(boolean renderRequiredIndicator) {
        this.renderRequiredIndicator = renderRequiredIndicator;
    }

    @BeanTagAttribute
    public String getRequiredIndicator() {
        return this.requiredIndicator;
    }

    public void setRequiredIndicator(String requiredIndicator) {
        this.requiredIndicator = requiredIndicator;
    }

    @BeanTagAttribute
    public Message getRichLabelMessage() {
        return this.richLabelMessage;
    }

    public void setRichLabelMessage(Message richLabelMessage) {
        this.richLabelMessage = richLabelMessage;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (tracer.getValidationStage() == 1 && this.isRender() && this.getLabelText() == null && !Validator.checkExpressions(this, "labelText")) {
            String[] currentValues = new String[]{"render = " + this.isRender(), "labelText =" + this.getLabelText()};
            tracer.createError("LabelText should be set if render is true", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

