/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.login;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.login.DummyLoginForm;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/login"})
public class DummyLoginController
extends UifControllerBase {
    @Override
    protected UifFormBase createInitialForm() {
        return new DummyLoginForm();
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=submit"})
    public ModelAndView submit(@ModelAttribute(value="KualiForm") DummyLoginForm uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String password;
        String returnUrl = this.decode(uifForm.getReturnLocation());
        if (StringUtils.isBlank((String)returnUrl)) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        Properties props = new Properties();
        String user = uifForm.getLogin_user();
        if (StringUtils.isNotBlank((String)user)) {
            props.put("__login_user", user);
        }
        if (StringUtils.isNotBlank((String)(password = uifForm.getLogin_pw()))) {
            props.put("__login_pw", password);
        }
        return this.performRedirect(uifForm, returnUrl, props);
    }

    @RequestMapping(params={"methodToCall=backdoorLogout"})
    public ModelAndView backdoorLogout(@ModelAttribute(value="KualiForm") DummyLoginForm uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession;
        String returnUrl = this.decode(uifForm.getReturnLocation());
        if (StringUtils.isBlank((String)returnUrl)) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        if ((userSession = KRADUtils.getUserSessionFromRequest(request)).isBackdoorInUse()) {
            userSession.clearBackdoorUser();
        }
        return this.performRedirect(uifForm, returnUrl, new Properties());
    }

    @RequestMapping(params={"methodToCall=logout"})
    public ModelAndView logout(@ModelAttribute(value="KualiForm") UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = GlobalVariables.getUserSession();
        if (userSession.isBackdoorInUse()) {
            userSession.clearBackdoorUser();
        }
        request.getSession().invalidate();
        return this.returnToHub(form);
    }

    private String decode(String encodedUrl) {
        if (StringUtils.isNotBlank((String)encodedUrl)) {
            return URLDecoder.decode(encodedUrl, StandardCharsets.UTF_8);
        }
        return null;
    }
}

