/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.engine;

import java.util.Map;

/**
 * An Engine executes using the given {@link SelectionCriteria}, @{link Facts}, and {@link ExecutionOptions} returning {@link EngineResults}
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Engine {

	/**
	 * Initiates execution of the rules engine.
	 * 
	 * @param selectionCriteria informs the engine of the {@link SelectionCriteria} to use for selection of contexts and agendas
	 * @param facts the facts that the rule engine can use during execution
	 * @param executionOptions defines various {@link ExecutionOptions} that instruct the rules engine on how to perform it's execution
	 * 
	 * @return {@link EngineResults} the results of engine execution
	 */
	EngineResults execute(SelectionCriteria selectionCriteria, Facts facts, ExecutionOptions executionOptions);

    /**
     * Initiates execution of the rules engine.
     *
     * @param selectionCriteria informs the engine of the {@link SelectionCriteria} to use for selection of contexts and agendas
     * @param facts the facts that the rule engine can use during execution.  Since this signature does not pass in
     * {@link Term}s, all terms are defined with only a name, and term parameters can not be specified.
     * @param executionOptions defines various {@link ExecutionOptions} that instruct the rules engine on how to perform it's execution
     *
     * @return the results of engine execution
     */
    EngineResults execute(SelectionCriteria selectionCriteria, Map<String, Object> facts, ExecutionOptions executionOptions);

}
