/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository;

import org.kuali.rice.core.api.exception.RiceRuntimeException;

/**
 * A runtime exception which indicates an unrecoverable data issue in the
 * rule repository.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RepositoryDataException extends RiceRuntimeException {

	private static final long serialVersionUID = 5856714188298264469L;

    /**
     * Default constructor
     */
	public RepositoryDataException() {
		super();
	}

    /**
     * @param message the exception message
     * @param cause the root Throwable cause.
     */
	public RepositoryDataException(String message, Throwable cause) {
		super(message, cause);
	}

    /**
     * @param message the exception message
     */
	public RepositoryDataException(String message) {
		super(message);
	}

    /**
     * @param cause the root Throwable cause.
     */
	public RepositoryDataException(Throwable cause) {
		super(cause);
	}
	
}
