/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.language;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * Defines the contract for a {@link NaturalLanguageUsage}
 *
 * @see NaturalLanguageUsage
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NaturalLanguageUsageContract extends Identifiable, Inactivatable, Versioned {

    /**
     * This is the Description of the NaturalLanguageUsage
     * <p>
     * The Description of the NaturalLanguageUsage
     * </p>
     * @return the Description of the NaturalLanguageUsage
     */
    public String getDescription();

    /**
     * This is the name of the NaturalLanguageUsage
     * <p>
     * The name of the NaturalLanguageUsage
     * </p>
     * @return the name of the NaturalLanguageUsage
     */
    public String getName();

    /**
     * This is the namespace of the NaturalLanguageUsage
     * <p>
     * The namespace of the NaturalLanguageUsage
     * </p>
     * @return the namespace of the NaturalLanguageUsage
     */
    public String getNamespace();
}
