/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.category;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.category.CategoryDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CategoryType", propOrder={"id", "name", "namespace", "versionNumber", "_futureElements"})
public class CategoryDefinition
extends AbstractDataTransferObject
implements CategoryDefinitionContract {
    private static final long serialVersionUID = -4748818967880857017L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private CategoryDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.versionNumber = null;
    }

    private CategoryDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements CategoryDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -5775478956373560840L;
        private String id;
        private String name;
        private String namespace;
        private Long versionNumber;

        private Builder(String id, String name, String namespace) {
            this.setId(id);
            this.setName(name);
            this.setNamespace(namespace);
        }

        public static Builder create(String id, String name, String namespace) {
            return new Builder(id, name, namespace);
        }

        public static Builder create(CategoryDefinitionContract category) {
            if (category == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(category.getId(), category.getName(), category.getNamespace());
            builder.setVersionNumber(category.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            if (null != id && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id must be null or non-blank");
            }
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public CategoryDefinition build() {
            return new CategoryDefinition(this);
        }
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String NAMESPACE = "namespace";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "category";
        static final String TYPE_NAME = "CategoryType";

        Constants() {
        }
    }
}

