/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.term;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.BuilderUtils;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="termResolverDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="termResolverDefinitionType", propOrder={"id", "name", "namespace", "typeId", "active", "output", "prerequisites", "attributes", "parameterNames", "versionNumber", "_futureElements"})
public final class TermResolverDefinition
extends AbstractDataTransferObject
implements TermResolverDefinitionContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="typeId", required=true)
    private final String typeId;
    @XmlElement(name="output", required=false)
    private final TermSpecificationDefinition output;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="termSpecificationDefinition", required=false)
    @XmlElementWrapper(name="prerequisites", required=false)
    private final Set<TermSpecificationDefinition> prerequisites;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElementWrapper(name="parameterNames", required=false)
    @XmlElement(name="parameterName")
    private final Set<String> parameterNames;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private TermResolverDefinition() {
        this.id = null;
        this.namespace = null;
        this.name = null;
        this.typeId = null;
        this.active = true;
        this.output = null;
        this.prerequisites = null;
        this.attributes = null;
        this.parameterNames = null;
        this.versionNumber = null;
    }

    private TermResolverDefinition(Builder builder) {
        this.id = builder.getId();
        this.namespace = builder.getNamespace();
        this.name = builder.getName();
        this.typeId = builder.getTypeId();
        this.active = builder.isActive();
        this.output = builder.getOutput().build();
        this.prerequisites = BuilderUtils.convertFromBuilderSet(builder.getPrerequisites());
        this.parameterNames = Collections.unmodifiableSet(builder.getParameterNames());
        this.versionNumber = builder.getVersionNumber();
        this.attributes = builder.attributes != null ? Collections.unmodifiableMap(builder.getAttributes()) : null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public TermSpecificationDefinition getOutput() {
        return this.output;
    }

    public Set<TermSpecificationDefinition> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements TermResolverDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String namespace;
        private String name;
        private String typeId;
        private boolean active;
        private TermSpecificationDefinition.Builder output;
        private Set<TermSpecificationDefinition.Builder> prerequisites;
        private Map<String, String> attributes;
        private Set<String> parameterNames;
        private Long versionNumber;

        private Builder(String id, String namespaceCode, String name, String typeId, TermSpecificationDefinition.Builder output, Set<TermSpecificationDefinition.Builder> prerequisites, Map<String, String> attributes, Set<String> parameterNames) {
            this.setId(id);
            this.setNamespace(namespaceCode);
            this.setName(name);
            this.setTypeId(typeId);
            this.setActive(true);
            this.setOutput(output);
            this.setPrerequisites(prerequisites);
            this.setAttributes(attributes);
            this.setParameterNames(parameterNames);
        }

        private Builder(TermResolverDefinitionContract termResolver) {
            this.setId(termResolver.getId());
            this.setNamespace(termResolver.getNamespace());
            this.setName(termResolver.getName());
            this.setTypeId(termResolver.getTypeId());
            this.setActive(termResolver.isActive());
            this.setOutput(TermSpecificationDefinition.Builder.create(termResolver.getOutput()));
            this.setPrerequisites(BuilderUtils.transform(termResolver.getPrerequisites(), TermSpecificationDefinition.Builder.toBuilder));
            this.setAttributes(termResolver.getAttributes());
            this.setParameterNames(termResolver.getParameterNames());
            this.setVersionNumber(termResolver.getVersionNumber());
        }

        public static Builder create(TermResolverDefinitionContract termResolver) {
            return new Builder(termResolver);
        }

        public static Builder create(String id, String namespaceCode, String name, String typeId, TermSpecificationDefinition.Builder output, Set<TermSpecificationDefinition.Builder> prerequisites, Map<String, String> attributes, Set<String> parameterNames) {
            return new Builder(id, namespaceCode, name, typeId, output, prerequisites, attributes, parameterNames);
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException();
            }
            this.id = id;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException();
            }
            this.namespace = namespace;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public void setTypeId(String typeId) {
            if (StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException();
            }
            this.typeId = typeId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setOutput(TermSpecificationDefinition.Builder output) {
            if (output == null) {
                throw new IllegalArgumentException();
            }
            this.output = output;
        }

        public void setPrerequisites(Set<TermSpecificationDefinition.Builder> prerequisites) {
            this.prerequisites = prerequisites;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        }

        public void setParameterNames(Set<String> parameterNames) {
            this.parameterNames = parameterNames;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public TermSpecificationDefinition.Builder getOutput() {
            return this.output;
        }

        public Set<TermSpecificationDefinition.Builder> getPrerequisites() {
            return this.prerequisites;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public Set<String> getParameterNames() {
            return this.parameterNames == null ? Collections.emptySet() : this.parameterNames;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public TermResolverDefinition build() {
            return new TermResolverDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/termResolverDefinitionType";
    }

    static class Elements {
        public static final String ID = "id";
        public static final String NAMESPACE = "namespace";
        public static final String NAME = "name";
        public static final String TYPE_ID = "typeId";
        public static final String OUTPUT = "output";
        public static final String PREREQUISITES = "prerequisites";
        public static final String ATTRIBUTES = "attributes";
        public static final String PARAMETER_NAMES = "parameterNames";
        public static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "termResolverDefinition";
        static final String TYPE_NAME = "termResolverDefinitionType";

        Constants() {
        }
    }
}

