/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.language;

import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krms.api.repository.BaseAttributeContract;

/**
 * Defines the contract for a {@link NaturalLanguageTemplateAttribute}.
 * @see NaturalLanguageTemplateAttribute
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public interface NaturalLanguageTemplateAttributeContract
    extends Versioned, BaseAttributeContract
{


    /**
     * This is the NaturalLanguageTemplateId of the NaturalLanguageTemplateAttribute
     * <p>
     * The NaturalLanguageTemplateId of the NaturalLanguageTemplateAttribute
     * </p>
     * @return the NaturalLanguageTemplateId of the NaturalLanguageTemplateAttribute
     * 
     */
    public String getNaturalLanguageTemplateId();

}
