/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import javax.xml.bind.JAXBContext;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;

public class PropositionParameterTest
implements GroovyObject {
    private static final String ID = "1001";
    private static final String PROP_ID = "202";
    private static final String VALUE = "campusCode";
    private static final String PARAMETER_TYPE_C;
    private static final String PARAMETER_TYPE_T;
    private static final String PARAMETER_TYPE_F;
    private static final String PARAMETER_TYPE_BAD;
    private static final Integer SEQUENCE_NUMBER_1;
    private static final String EXPECTED_XML = "\n\t\t<PropositionParameter xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<id>1001</id>\n\t\t\t<propId>202</propId>\n\t\t\t<value>campusCode</value>\n\t\t\t<parameterType>C</parameterType>\n\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t</PropositionParameter>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public PropositionParameterTest() {
        this.metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, null, null, null, null, null);
    }

    @Test
    public void test_Builder_create_null_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, null, PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, "", PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, "    ", PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_Builder_create_null_prop_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, null, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_prop_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, "", VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_prop_id() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, "   ", VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_Builder_create_succeed_null_value() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, null, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_value() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, "", PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_value() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, "    ", PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_parameter_type() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, null, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_parameter_type() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, "", SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_parameter_type() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, "\t  ", SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_invalid_parameter_type() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, PARAMETER_TYPE_BAD, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_sequence_number() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, PARAMETER_TYPE_C, null);
    }

    @Test
    public void test_create_only_required() {
        IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_create_and_build_only_required() {
        IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1));
    }

    @Test
    public void testXmlMarshaling() {
        CallSite myParameter = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "create", 0, PropositionParameter.Builder.class, ID, PROP_ID, VALUE, PARAMETER_TYPE_C, SEQUENCE_NUMBER_1)));
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, PropositionParameter.class));
        CallSite marshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createMarshaller", 0, jc));
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        IndyInterface.bootstrap("invoke", "marshal", 0, marshaller, myParameter, sw);
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite actual = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, xml));
        CallSite expected = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, expected, actual);
    }

    @Test
    public void testXmlUnmarshal() {
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, PropositionParameter.class));
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite myParameter = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ID, IndyInterface.bootstrap("getProperty", "id", 0, myParameter));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, PROP_ID, IndyInterface.bootstrap("getProperty", "propId", 0, myParameter));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, VALUE, IndyInterface.bootstrap("getProperty", "value", 0, myParameter));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, PARAMETER_TYPE_C, IndyInterface.bootstrap("getProperty", "parameterType", 0, myParameter));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, SEQUENCE_NUMBER_1, IndyInterface.bootstrap("getProperty", "sequenceNumber", 0, myParameter));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PropositionParameterTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        PARAMETER_TYPE_BAD = "X";
        PARAMETER_TYPE_F = "F";
        PARAMETER_TYPE_T = "T";
        PARAMETER_TYPE_C = "C";
        SEQUENCE_NUMBER_1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Integer.class, true));
    }
}

