/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.reference;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * Defines the contract for a {@link ReferenceObjectBinding}
 *
 * @see ReferenceObjectBinding
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ReferenceObjectBindingContract extends Identifiable, Inactivatable, Versioned {
    /**
     * This is the CollectionName of the ReferenceObjectBinding
     * <p>
     * The CollectionName of the ReferenceObjectBinding
     * </p>
     * @return the CollectionName of the ReferenceObjectBinding
     */
    public String getCollectionName();

    /**
     * This is the KrmsDiscriminatorType of the ReferenceObjectBinding
     * <p>
     * The KrmsDiscriminatorType of the ReferenceObjectBinding
     * </p>
     * @return the KrmsDiscriminatorType of the ReferenceObjectBinding
     */
    public String getKrmsDiscriminatorType();

    /**
     * This is the KrmsObjectId of the ReferenceObjectBinding
     * <p>
     * The KrmsObjectId of the ReferenceObjectBinding
     * </p>
     * @return the KrmsObjectId of the ReferenceObjectBinding
     */
    public String getKrmsObjectId();

    /**
     * This is the namespace of the ReferenceObjectBinding
     * <p>
     * The namespace of the ReferenceObjectBinding
     * </p>
     * @return the namespace of the ReferenceObjectBinding
     */
    public String getNamespace();

    /**
     * This is the ReferenceDiscriminatorType of the ReferenceObjectBinding
     * <p>
     * The ReferenceDiscriminatorType of the ReferenceObjectBinding
     * </p>
     * @return the ReferenceDiscriminatorType of the ReferenceObjectBinding
     */
    public String getReferenceDiscriminatorType();

    /**
     * This is the ReferenceObjectId of the ReferenceObjectBinding
     * <p>
     * The ReferenceObjectId of the ReferenceObjectBinding
     * </p>
     * @return the ReferenceObjectId of the ReferenceObjectBinding
     */
    public String getReferenceObjectId();


}
