/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import java.util.Comparator;

/**
 *
 * For creating custom ComparisonOperator.
 *
 * @link ComparisonOperator
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface EngineComparatorExtension<A> extends Comparator<A> {

    /**
     *
     * @param lhs
     * @param rhs
     * @return int where 0 is equals - is less than and + is greater than
     */
    @Override
    public int compare(A lhs, A rhs);

    /**
     * Return Object created from the value passed in.
     *
     * @param s
     * @return
     */
//    A coerce(String s);

    /**
     *
     * @param lhs
     * @param rhs
     * @return able to compare lhs and rhs
     */
    boolean canCompare(Object lhs, Object rhs);
}
