/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.language;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.w3c.dom.Element;

@XmlRootElement(name="naturalLanguageTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="NaturalLanguageTemplateType", propOrder={"attributes", "languageCode", "naturalLanguageUsageId", "typeId", "template", "id", "active", "versionNumber", "_futureElements"})
public final class NaturalLanguageTemplate
extends AbstractDataTransferObject
implements NaturalLanguageTemplateContract {
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    @XmlElement(name="attributes", required=false)
    private final Map<String, String> attributes;
    @XmlElement(name="languageCode", required=false)
    private final String languageCode;
    @XmlElement(name="naturalLanguageUsageId", required=false)
    private final String naturalLanguageUsageId;
    @XmlElement(name="typeId", required=false)
    private final String typeId;
    @XmlElement(name="template", required=false)
    private final String template;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private NaturalLanguageTemplate() {
        this.attributes = null;
        this.languageCode = null;
        this.naturalLanguageUsageId = null;
        this.typeId = null;
        this.template = null;
        this.id = null;
        this.active = true;
        this.versionNumber = null;
    }

    private NaturalLanguageTemplate(Builder builder) {
        this.attributes = builder.getAttributes();
        this.languageCode = builder.getLanguageCode();
        this.naturalLanguageUsageId = builder.getNaturalLanguageUsageId();
        this.typeId = builder.getTypeId();
        this.template = builder.getTemplate();
        this.id = builder.getId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public String getNaturalLanguageUsageId() {
        return this.naturalLanguageUsageId;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    NaturalLanguageTemplateContract {
        private Map<String, String> attributes;
        private String languageCode;
        private String naturalLanguageUsageId;
        private String typeId;
        private String template;
        private String id;
        private boolean active;
        private Long versionNumber;

        private Builder(String languageCode, String naturalLanguageUsageId, String template, String typeId) {
            this.setAttributes(null);
            this.setLanguageCode(languageCode);
            this.setNaturalLanguageUsageId(naturalLanguageUsageId);
            this.setTemplate(template);
            this.setTypeId(typeId);
        }

        public static Builder create(String languageCode, String naturalLanguageUsageId, String template, String typeId) {
            return new Builder(languageCode, naturalLanguageUsageId, template, typeId);
        }

        public static Builder create(NaturalLanguageTemplateContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getLanguageCode(), contract.getNaturalLanguageUsageId(), contract.getTemplate(), contract.getTypeId());
            builder.setId(contract.getId());
            builder.setActive(contract.isActive());
            builder.setAttributes(contract.getAttributes());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public NaturalLanguageTemplate build() {
            return new NaturalLanguageTemplate(this);
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public String getNaturalLanguageUsageId() {
            return this.naturalLanguageUsageId;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setLanguageCode(String languageCode) {
            if (StringUtils.isBlank((String)languageCode)) {
                throw new IllegalArgumentException("languageCode is null or blank");
            }
            this.languageCode = languageCode;
        }

        public void setNaturalLanguageUsageId(String naturalLanguageUsageId) {
            if (StringUtils.isBlank((String)naturalLanguageUsageId)) {
                throw new IllegalArgumentException("naturalLanguageUsageId is null or blank");
            }
            this.naturalLanguageUsageId = naturalLanguageUsageId;
        }

        public void setTemplate(String template) {
            if (StringUtils.isBlank((String)template)) {
                throw new IllegalArgumentException("template is null or blank");
            }
            this.template = template;
        }

        public void setTypeId(String typeId) {
            if (StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException("typeId is null or blank");
            }
            this.typeId = typeId;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType";
    }

    static class Elements {
        static final String ATTRIBUTES = "attributes";
        static final String LANGUAGE_CODE = "languageCode";
        static final String NATURAL_LANGUAGE_USAGE_ID = "naturalLanguageUsageId";
        static final String TYPE_ID = "typeId";
        static final String TEMPLATE = "template";
        static final String ID = "id";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "naturalLanguageTemplate";
        static final String TYPE_NAME = "NaturalLanguageTemplateType";

        Constants() {
        }
    }
}

