/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.function;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * Defines the contract for a function parameter definition.  A function
 * parameter definition helps to define the "signature" of a
 * {@link FunctionDefinitionContract} by defining the name and type of an
 * expected parameter to the function.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface FunctionParameterDefinitionContract extends Versioned, Identifiable {

	/**
	 * Returns the name of this parameters.  All parameters have a name and this
	 * value can never be null or blank.  The parameter name must be unique
	 * within a given function definition.
	 * 
	 * @return the name of this function parameter definition
	 */
	String getName();
	
	/**
	 * Returns the description of this parameter.  The description is intended
	 * to provide more information about a parameter and it's appropriate
	 * usage.  The description is optional and will be null if a
	 * description is not defined.
	 * 
	 * @return the description of this function parameter definition, or null
	 * if this parameter has no description
	 */
	String getDescription();
	
	/**
	 * Returns the type of this function parameter.  This can be one of a set
	 * of "built-in" data types or a custom data type represented as a fully
	 * qualified java class name.  All parameters must have a valid type so
	 * this method should never return null or blank.
	 * 
	 * @return the type of this function parameter definition
	 */
	String getParameterType();
	
	/**
	 * Returns the ID of the function to which this parameter is associated.
	 * 
	 * @return the ID of the corresponding function
	 */
	String getFunctionId();

	/**
	 * This is the sequence number of the function parameter.
	 * The sequence number identifies the position of the 
	 * parameter in the function list.
	 * 
	 * @return the sequence number of the function parameter
	 */
	public Integer getSequenceNumber();
}
