/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

/**
 * Interface to extend to implement custom coerce of {@link String}s to an instance of the given type, when when validating
 * {@link org.kuali.rice.krms.framework.engine.Proposition} {@link org.kuali.rice.krms.api.engine.Term}s
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface StringCoercionExtension {

    /**
     * Can this StringCoercionExtension coerce the given type and value into an Object?
     * @param type of Object to coerce to.
     * @param value value to use for coerced type
     * @return boolean true if this StringCoercionExtension can coerce this type and value
     */
    boolean canCoerce(String type, String value);

    /**
     * Returns an Object of the given type populated with the given value.
     * @param type to coerce Object to
     * @param value to coerce
     * @return Object of given type with given value
     */
    Object coerce(String type, String value);
}
