/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.term;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.BuilderUtils;
import org.kuali.rice.krms.api.repository.category.CategoryDefinition;
import org.kuali.rice.krms.api.repository.category.CategoryDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="termSpecification")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="TermSpecificationType", propOrder={"id", "name", "namespace", "type", "description", "active", "versionNumber", "categories", "contextIds", "_futureElements"})
public final class TermSpecificationDefinition
extends AbstractDataTransferObject
implements TermSpecificationDefinitionContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="type", required=true)
    private final String type;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElementWrapper(name="categories", required=false)
    @XmlElement(name="category", required=false)
    private final List<CategoryDefinition> categories;
    @XmlElementWrapper(name="contexts", required=false)
    @XmlElement(name="contextId", required=false)
    private final List<String> contextIds;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private TermSpecificationDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.type = null;
        this.description = null;
        this.active = true;
        this.versionNumber = null;
        this.categories = null;
        this.contextIds = null;
    }

    private TermSpecificationDefinition(Builder b) {
        this.id = b.getId();
        this.name = b.getName();
        this.namespace = b.getNamespace();
        this.type = b.getType();
        this.description = b.getDescription();
        this.active = b.isActive();
        this.versionNumber = b.getVersionNumber();
        this.categories = TermSpecificationDefinition.constructCategories(b.getCategories());
        this.contextIds = Collections.unmodifiableList(new ArrayList<String>(b.getContextIds()));
    }

    private static List<CategoryDefinition> constructCategories(List<CategoryDefinition.Builder> categoryBuilders) {
        ArrayList<CategoryDefinition> categories = new ArrayList<CategoryDefinition>();
        if (categoryBuilders != null) {
            for (CategoryDefinition.Builder categoryBuilder : categoryBuilders) {
                categories.add(categoryBuilder.build());
            }
        }
        return categories;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public List<CategoryDefinition> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public List<String> getContextIds() {
        return this.contextIds;
    }

    public static class Builder
    implements TermSpecificationDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String termSpecificationId;
        private String name;
        private String namespace;
        private String type;
        private String description;
        private boolean active;
        private Long versionNumber;
        private List<CategoryDefinition.Builder> categories;
        private List<String> contextIds;
        private static final String NON_NULL_NON_EMPTY_ERROR = " must be non-null and must contain non-whitespace chars";
        public static final BuilderUtils.Transformer<TermSpecificationDefinitionContract, Builder> toBuilder = new BuilderUtils.Transformer<TermSpecificationDefinitionContract, Builder>(){

            @Override
            public Builder transform(TermSpecificationDefinitionContract input) {
                return Builder.create(input);
            }
        };

        private Builder(String termSpecificationId, String name, String namespace, String type) {
            this.setId(termSpecificationId);
            this.setNamespace(namespace);
            this.setName(name);
            this.setType(type);
            this.setActive(true);
            this.setCategories(new ArrayList<CategoryDefinition.Builder>());
            this.setContextIds(new ArrayList<String>());
        }

        public static Builder create(String termSpecificationId, String name, String namespace, String type) {
            return new Builder(termSpecificationId, name, namespace, type);
        }

        public static Builder create(TermSpecificationDefinitionContract termSpecification) {
            if (termSpecification == null) {
                throw new IllegalArgumentException("termSpecification must be non-null");
            }
            Builder builder = new Builder(termSpecification.getId(), termSpecification.getName(), termSpecification.getNamespace(), termSpecification.getType());
            builder.setDescription(termSpecification.getDescription());
            builder.setActive(termSpecification.isActive());
            builder.setVersionNumber(termSpecification.getVersionNumber());
            for (CategoryDefinitionContract categoryDefinitionContract : termSpecification.getCategories()) {
                builder.getCategories().add(CategoryDefinition.Builder.create(categoryDefinitionContract));
            }
            if (termSpecification.getContextIds() != null) {
                builder.getContextIds().addAll(termSpecification.getContextIds());
            }
            return builder;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setId(String termSpecificationId) {
            if (termSpecificationId != null && StringUtils.isBlank((String)termSpecificationId)) {
                throw new IllegalArgumentException("termSpecificationId must contain non-whitespace chars");
            }
            this.termSpecificationId = termSpecificationId;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace must be non-null and must contain non-whitespace chars");
            }
            this.namespace = namespace;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name must be non-null and must contain non-whitespace chars");
            }
            this.name = name;
        }

        public void setType(String type) {
            if (StringUtils.isBlank((String)type)) {
                throw new IllegalArgumentException("type must be non-null and must contain non-whitespace chars");
            }
            this.type = type;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setCategories(List<CategoryDefinition.Builder> categories) {
            if (categories == null) {
                throw new IllegalArgumentException("categories was null");
            }
            this.categories = categories;
        }

        public void setContextIds(List<String> contextIds) {
            if (contextIds == null) {
                throw new IllegalArgumentException("contextIds was null");
            }
            this.contextIds = contextIds;
        }

        public String getId() {
            return this.termSpecificationId;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public boolean isActive() {
            return this.active;
        }

        public List<CategoryDefinition.Builder> getCategories() {
            return this.categories;
        }

        @Override
        public List<String> getContextIds() {
            return this.contextIds;
        }

        public TermSpecificationDefinition build() {
            return new TermSpecificationDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/TermSpecificationType";
    }

    static class Elements {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String NAMESPACE = "namespace";
        public static final String TYPE = "type";
        public static final String DESCRIPTION = "description";
        public static final String ACTIVE = "active";
        public static final String CATEGORIES = "categories";
        public static final String CATEGORY = "category";
        public static final String CONTEXTS = "contexts";
        public static final String CONTEXT_ID = "contextId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "termSpecification";
        static final String TYPE_NAME = "TermSpecificationType";

        Constants() {
        }
    }
}

