/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;

public class KrmsTypeAttributeTest
implements GroovyObject {
    private static final String NAMESPACE = "KRMS_UNIT_TEST";
    private static final String ID = "ORG_ATTR_1";
    private static final String TYPE_ID = "1234ABCD";
    private static final String ATTR_DEF_ID = "1001";
    private static final Integer SEQUENCE_NUMBER_1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Integer.class, true));
    private static final String ORG_NAME = "ORG";
    private static final String ORG_LABEL = "Organization";
    private static final String COMPONENT = "someOrgComponent";
    private static final String EXPECTED_XML = "\n\t\t<krmsTypeAttribute xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<typeId>1234ABCD</typeId>\n\t\t\t<attributeDefinitionId>1001</attributeDefinitionId>\n\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t<active>true</active>\n\t\t</krmsTypeAttribute>\n\t";
    private static final String EXPECTED_XML_2 = "\n\t\t<krmsTypeAttribute xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<id>ORG_ATTR_1</id>\n\t\t\t<typeId>1234ABCD</typeId>\n\t\t\t<attributeDefinitionId>1001</attributeDefinitionId>\n\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t<active>true</active>\n\t\t</krmsTypeAttribute>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public KrmsTypeAttributeTest() {
        this.metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, null, null, null);
    }

    @Test
    public void test_Builder_create_null_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_Builder_create_null_type_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, null, ATTR_DEF_ID, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty__type_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, "", ATTR_DEF_ID, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace__type_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, "   ", ATTR_DEF_ID, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_attr_def_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, null, SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_attr_def_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, "", SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_attr_def_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, "    ", SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_sequence_number() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, null);
    }

    @Test
    public void test_create_only_required() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_create_and_build_only_required() {
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, TYPE_ID, IndyInterface.bootstrap("invoke", "getTypeId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ATTR_DEF_ID, IndyInterface.bootstrap("invoke", "getAttributeDefinitionId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, SEQUENCE_NUMBER_1, IndyInterface.bootstrap("invoke", "getSequenceNumber", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myAttr));
    }

    @Test
    public void test_create_and_build_with_attribute_definition() {
        CallSite myAttrBuilder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1));
        IndyInterface.bootstrap("invoke", "setId", 0, myAttrBuilder, ID);
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, myAttrBuilder));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ID, IndyInterface.bootstrap("invoke", "getId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, TYPE_ID, IndyInterface.bootstrap("invoke", "getTypeId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ATTR_DEF_ID, IndyInterface.bootstrap("invoke", "getAttributeDefinitionId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, SEQUENCE_NUMBER_1, IndyInterface.bootstrap("invoke", "getSequenceNumber", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myAttr));
    }

    @Test
    public void testXmlMarshaling() {
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1)));
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, KrmsTypeAttribute.class));
        CallSite marshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createMarshaller", 0, jc));
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        IndyInterface.bootstrap("invoke", "marshal", 0, marshaller, myAttr, sw);
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite actual = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, xml));
        CallSite expected = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, expected, actual);
    }

    @Test
    public void testXmlUnmarshal() {
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, KrmsTypeAttribute.class));
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, TYPE_ID, IndyInterface.bootstrap("getProperty", "typeId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ATTR_DEF_ID, IndyInterface.bootstrap("getProperty", "attributeDefinitionId", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, SEQUENCE_NUMBER_1, IndyInterface.bootstrap("getProperty", "sequenceNumber", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("getProperty", "active", 0, myAttr));
    }

    @Test
    public void testXmlMarshalingWithDefinition() {
        CallSite myAttrBuilder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsTypeAttribute.Builder.class, TYPE_ID, ATTR_DEF_ID, SEQUENCE_NUMBER_1));
        IndyInterface.bootstrap("invoke", "setId", 0, myAttrBuilder, ID);
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, myAttrBuilder));
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, KrmsTypeAttribute.class, KrmsAttributeDefinition.class));
        CallSite marshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createMarshaller", 0, jc));
        IndyInterface.bootstrap("invoke", "setProperty", 0, marshaller, IndyInterface.bootstrap("getProperty", "JAXB_FORMATTED_OUTPUT", 0, Marshaller.class), true);
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        IndyInterface.bootstrap("invoke", "marshal", 0, marshaller, myAttr, sw);
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
        IndyInterface.bootstrap("invoke", "print", 2, this, xml);
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite actual = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, xml));
        CallSite expected = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML_2));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, expected, actual);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KrmsTypeAttributeTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

