/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;

public class KrmsAttributeDefinitionTest
implements GroovyObject {
    private static final String NAMESPACE = "KRMS_UNIT_TEST";
    private static final String ID_1 = "1001";
    private static final String ORG_NAME = "ORG";
    private static final String ORG_LABEL = "Organization";
    private static final String COMPONENT = "someOrgComponent";
    private static final Integer SEQUENCE_NUMBER_1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Integer.class, true));
    private static final String EXPECTED_XML = "\n\t\t<KrmsAttributeDefinition xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<id>1001</id>\n\t\t\t<name>ORG</name>\n\t\t\t<namespace>KRMS_UNIT_TEST</namespace>\n\t\t\t<label>Organization</label>\n\t\t\t<active>1</active>\n\t\t\t<componentName>someOrgComponent</componentName>\n\t\t</KrmsAttributeDefinition>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public KrmsAttributeDefinitionTest() {
        this.metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, null, null, null);
    }

    @Test
    public void test_Builder_create_null_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, null, ORG_NAME, NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, "", ORG_NAME, NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_id() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, "    ", ORG_NAME, NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_name() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, null, NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty__name() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, "", NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace__name() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, "   ", NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_namespace() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_namespace() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_namespace() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, "    ");
    }

    @Test
    public void test_create_only_required() {
        IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE);
    }

    @Test
    public void test_create_and_build_only_required() {
        CallSite myDef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("invoke", "getName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("invoke", "getNamespace", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myDef));
    }

    @Test
    public void test_create_and_build_with_label() {
        CallSite myDef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "label", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE), ORG_LABEL)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("invoke", "getName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("invoke", "getNamespace", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_LABEL, IndyInterface.bootstrap("getProperty", "label", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myDef));
    }

    @Test
    public void test_create_and_build_with_component() {
        CallSite myDef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "componentName", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE), COMPONENT)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("invoke", "getName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("invoke", "getNamespace", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, COMPONENT, IndyInterface.bootstrap("getProperty", "componentName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myDef));
    }

    @Test
    public void test_create_and_build_with_label_and_component_fluent() {
        CallSite myDef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "componentName", 0, IndyInterface.bootstrap("invoke", "label", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE), ORG_LABEL), COMPONENT)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("invoke", "getName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("invoke", "getNamespace", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_LABEL, IndyInterface.bootstrap("getProperty", "label", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, COMPONENT, IndyInterface.bootstrap("getProperty", "componentName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myDef));
    }

    @Test
    public void test_create_and_build_with_label_and_component() {
        CallSite myBuilder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE));
        IndyInterface.bootstrap("invoke", "setLabel", 0, myBuilder, ORG_LABEL);
        IndyInterface.bootstrap("invoke", "setComponentName", 0, myBuilder, COMPONENT);
        CallSite myDef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, myBuilder));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("invoke", "getName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("invoke", "getNamespace", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_LABEL, IndyInterface.bootstrap("getProperty", "label", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, COMPONENT, IndyInterface.bootstrap("getProperty", "componentName", 0, myDef));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "isActive", 0, myDef));
    }

    @Test
    public void testXmlMarshaling() {
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildFullKrmsAttributeDefinition", 0, KrmsAttributeDefinitionTest.class));
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, KrmsAttributeDefinition.class));
        CallSite marshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createMarshaller", 0, jc));
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        IndyInterface.bootstrap("invoke", "setProperty", 0, marshaller, IndyInterface.bootstrap("getProperty", "JAXB_FORMATTED_OUTPUT", 0, Marshaller.class), true);
        IndyInterface.bootstrap("invoke", "marshal", 0, marshaller, myAttr, sw);
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
        IndyInterface.bootstrap("invoke", "print", 2, this, xml);
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite actual = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, xml));
        CallSite expected = IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, expected, actual);
    }

    public static KrmsAttributeDefinition buildFullKrmsAttributeDefinition() {
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "componentName", 0, IndyInterface.bootstrap("invoke", "label", 0, IndyInterface.bootstrap("invoke", "create", 0, KrmsAttributeDefinition.Builder.class, ID_1, ORG_NAME, NAMESPACE), ORG_LABEL), COMPONENT)));
        return myAttr;
    }

    @Test
    public void testXmlUnmarshal() {
        CallSite jc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, JAXBContext.class, KrmsAttributeDefinition.class));
        CallSite unmarshaller = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUnmarshaller", 0, jc));
        CallSite myAttr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unmarshal", 0, unmarshaller, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, EXPECTED_XML)));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ID_1, IndyInterface.bootstrap("getProperty", "id", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_NAME, IndyInterface.bootstrap("getProperty", "name", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, NAMESPACE, IndyInterface.bootstrap("getProperty", "namespace", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, ORG_LABEL, IndyInterface.bootstrap("getProperty", "label", 0, myAttr));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, COMPONENT, IndyInterface.bootstrap("getProperty", "componentName", 0, myAttr));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KrmsAttributeDefinitionTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

