/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.Rule;

/**
 * Interface for defining the loading of a {@link Rule} given a {@link RuleDefinition}
 *
 * @see Rule
 * @see RuleDefinition
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface RuleTypeService extends RemotableAttributeOwner {

    /**
     * Load the {@link Rule} given the {@link RuleDefinition}
     * @param ruleDefinition {@link RuleDefinition} to create a {@link Rule} from
     * @return {@link Rule} created from the given {@link RuleDefinition}
     */
	public Rule loadRule(RuleDefinition ruleDefinition);

}
