/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.result;

import org.kuali.rice.krms.api.engine.ResultEvent;

/**
 * A Log4j implementation of {@link ResultListener} which logs the output of the {@link ResultEvent} toString at the INFO
 * level to the Log4jResultListener.class org.apache.logging.log4j.Logger
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class Log4jResultListener  implements ResultListener {
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(Log4jResultListener.class);

	public Log4jResultListener(){}
	
	@Override
	public void handleEvent(ResultEvent resultEvent) {

		if (LOG.isInfoEnabled()){
			LOG.info(resultEvent);
		}
		
	}

}
