/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.framework.engine.Agenda;

/**
 * {@link AgendaTypeService} provides access and validation for custom attributes on the agenda type.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface AgendaTypeService extends RemotableAttributeOwner {

    /**
     * Load an Agenda created from the given {@link AgendaDefinition}
     * @param agendaDefinition defines the {@link Agenda} to create
     * @return Agenda created from the given {@link AgendaDefinition}
     */
    public Agenda loadAgenda(AgendaDefinition agendaDefinition);

}
