/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.Context;

public final class BasicContext
implements Context {
    private final List<Agenda> agendas;
    private final List<TermResolver<?>> termResolvers;

    public BasicContext(List<Agenda> agendas, List<TermResolver<?>> termResolvers) {
        this.agendas = agendas;
        this.termResolvers = termResolvers;
    }

    @Override
    public void execute(ExecutionEnvironment environment) {
        if (this.termResolvers != null) {
            for (TermResolver<?> termResolver : this.termResolvers) {
                environment.addTermResolver(termResolver);
            }
        }
        List<Agenda> matchingAgendas = this.findMatchingAgendas(environment);
        for (Agenda matchingAgenda : matchingAgendas) {
            matchingAgenda.execute(environment);
        }
    }

    private List<Agenda> findMatchingAgendas(ExecutionEnvironment environment) {
        ArrayList<Agenda> matchingAgendas = new ArrayList<Agenda>();
        for (Agenda agenda : this.agendas) {
            if (!agenda.appliesTo(environment)) continue;
            matchingAgendas.add(agenda);
        }
        return matchingAgendas;
    }

    @Override
    public List<TermResolver<?>> getTermResolvers() {
        return Collections.unmodifiableList(this.termResolvers);
    }
}

