/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import java.util.Collections;
import java.util.Map;

/**
 * PropositionResults are returned by {@link Proposition}'s evaluate method.
 * @see Proposition evaluate
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PropositionResult {

	final boolean result;
	Map<String,?> executionDetails;

    /**
     * Create a PropositionResult with the given result
     * @param result to set the result to
     */
	public PropositionResult(boolean result) {
	    this(result, null);
	}

    /**
     * Create a PropositionResult with the given values
     * @param result to set the result to
     * @param executionDetails to set executionDetails to
     */
	public PropositionResult(boolean result, Map<String,?> executionDetails) {
		this.result = result;
		
		if (executionDetails == null) {
		    this.executionDetails = Collections.emptyMap();
		} else {
		    this.executionDetails = Collections.unmodifiableMap(executionDetails);
		}
	}

    /**
     * Returns the result.
     * @return the result
     */
	public boolean getResult() {
		return result;
	}

    /**
     * Returns the executionDetails
     * @return the executionDetails
     */
	public Map<String,?> getExecutionDetails() {
		return executionDetails;
	}
		
}
