/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import java.util.Arrays;
import java.util.List;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * An implementation of {@link AgendaTree} that executes a {@link ExecutionEnvironment} over its list of {@link AgendaTreeEntry}s.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class BasicAgendaTree implements AgendaTree {
	
	private final List<AgendaTreeEntry> entries;

    /**
     * Create a BasicAgendaTree with the given {@link AgendaTreeEntry}s
     * @param entries - {@link AgendaTreeEntry}s to create a BasicAgendaTree with
     */
	public BasicAgendaTree(AgendaTreeEntry... entries) {
		this.entries = Arrays.asList(entries);
	}

    /**
     * Create a BasicAgendaTree with the given {@link AgendaTreeEntry}s
     * @param entries - {@link AgendaTreeEntry}s to create a BasicAgendaTree with
     * @throws IllegalArgumentException if the entries list is null
     */
	public BasicAgendaTree(List<AgendaTreeEntry> entries) {
		if (entries == null) {
			throw new IllegalArgumentException("entries list was null");
		}
		this.entries = entries;		
	}
	
    @Override
	public void execute(ExecutionEnvironment environment) {
		for (AgendaTreeEntry entry : entries) {
			entry.execute(environment);
		}
	}
	
}
